<?php
$page_title = "Word Counter - Count Words, Characters & SEO Metrics | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Word Counter",
        "description": "Free online word counter tool to count words, characters, sentences, paragraphs, and analyze reading time, keyword density, and SEO metrics for content optimization.",
        "url": "<?php echo $base_url; ?>/tools/word-counter",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Word and character counting",
            "Sentence and paragraph analysis",
            "Reading time estimation",
            "Keyword density analysis",
            "SEO metrics calculation",
            "Real-time statistics",
            "Content optimization tips"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Word Counter</h1>
                    <p class="fade-in">Count words, characters, and analyze SEO metrics for better content optimization and readability.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Enter Text to Analyze</h3>
                        <form id="wordCounterForm">
                            <div class="mb-3">
                                <label for="textInput" class="form-label">Text Content</label>
                                <textarea class="form-control" id="textInput" rows="8" placeholder="Paste your text content here to count words, characters, and analyze metrics..." required></textarea>
                                <div class="form-text">Enter any text content, articles, blog posts, or documents for comprehensive analysis.</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Analysis Options</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="countWords" checked>
                                            <label class="form-check-label" for="countWords">
                                                Word Count & Statistics
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="countChars" checked>
                                            <label class="form-check-label" for="countChars">
                                                Character Count (with/without spaces)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="readingTime" checked>
                                            <label class="form-check-label" for="readingTime">
                                                Reading Time Estimation
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="keywordDensity" checked>
                                            <label class="form-check-label" for="keywordDensity">
                                                Keyword Density Analysis
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="seoMetrics" checked>
                                            <label class="form-check-label" for="seoMetrics">
                                                SEO Metrics & Recommendations
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="readability" checked>
                                            <label class="form-check-label" for="readability">
                                                Basic Readability Score
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Analyze Text</button>
                        </form>
                    </div>

                    <!-- Live Statistics (shown while typing) -->
                    <div id="liveStats" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Live Statistics</h4>
                            <div class="row text-center">
                                <div class="col-md-3">
                                    <div class="stat-box">
                                        <h3 id="liveWords">0</h3>
                                        <p>Words</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="stat-box">
                                        <h3 id="liveChars">0</h3>
                                        <p>Characters</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="stat-box">
                                        <h3 id="liveSentences">0</h3>
                                        <p>Sentences</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="stat-box">
                                        <h3 id="liveParagraphs">0</h3>
                                        <p>Paragraphs</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Text Analysis Results</h4>
                            <div id="wordCountResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Word Counting: Understanding Text Metrics and SEO Optimization</h2>

                        <p>Word counting is a fundamental content analysis technique that goes beyond simple word totals to provide comprehensive insights into text structure, readability, and SEO performance. This guide explores word counting methodologies, content metrics, and their applications in content creation and optimization.</p>

                        <h3>What is Word Counting?</h3>

                        <p>Word counting involves analyzing text to determine various metrics that help understand content structure, length, and quality. Modern word counters go beyond simple word totals to provide comprehensive statistics that inform content strategy and optimization.</p>

                        <h4>Basic Word Counting Metrics</h4>

                        <p>Essential metrics that every word counter should provide:</p>

                        <ul>
                            <li><strong>Word Count:</strong> Total number of words in the text</li>
                            <li><strong>Character Count:</strong> Total characters with and without spaces</li>
                            <li><strong>Sentence Count:</strong> Number of sentences in the text</li>
                            <li><strong>Paragraph Count:</strong> Number of paragraphs</li>
                            <li><strong>Line Count:</strong> Number of lines (for formatted text)</li>
                        </ul>

                        <h3>Advanced Text Analysis</h3>

                        <h4>Reading Time Estimation</h4>

                        <p>Calculating how long it takes to read content:</p>

                        <ul>
                            <li><strong>Average Reading Speed:</strong> 200-250 words per minute for adults</li>
                            <li><strong>Slow Readers:</strong> 150-180 words per minute</li>
                            <li><strong>Fast Readers:</strong> 300-400 words per minute</li>
                            <li><strong>Technical Content:</strong> Slower reading speeds</li>
                        </ul>

                        <h4>Speaking Time Estimation</h4>

                        <p>Converting word count to speaking time:</p>

                        <ul>
                            <li><strong>Average Speaking Rate:</strong> 120-150 words per minute</li>
                            <li><strong>Presentation Speech:</strong> 100-120 words per minute</li>
                            <li><strong>Conversational Speech:</strong> 150-180 words per minute</li>
                        </ul>

                        <h3>SEO and Content Optimization</h3>

                        <h4>Optimal Content Length</h4>

                        <p>Different content types have different ideal lengths:</p>

                        <h5>Blog Posts</h5>

                        <ul>
                            <li><strong>Short Posts:</strong> 300-500 words</li>
                            <li><strong>Standard Posts:</strong> 600-800 words</li>
                            <li><strong>Long-form Content:</strong> 1,500-2,500 words</li>
                            <li><strong>In-depth Guides:</strong> 3,000+ words</li>
                        </ul>

                        <h5>Social Media</h5>

                        <ul>
                            <li><strong>Tweets:</strong> 1-280 characters</li>
                            <li><strong>Facebook Posts:</strong> 40-80 words</li>
                            <li><strong>LinkedIn Articles:</strong> 1,900-2,000 words</li>
                            <li><strong>Instagram Captions:</strong> 125-150 words</li>
                        </ul>

                        <h4>Keyword Density Analysis</h4>

                        <p>Analyzing keyword usage in content:</p>

                        <ul>
                            <li><strong>Primary Keywords:</strong> 1-2% density</li>
                            <li><strong>Secondary Keywords:</strong> 0.5-1% density</li>
                            <li><strong>LSI Keywords:</strong> 0.3-0.7% density</li>
                            <li><strong>Over-optimization:</strong> Avoid exceeding 3-4%</li>
                        </ul>

                        <h3>Content Quality Metrics</h3>

                        <h4>Readability Scores</h4>

                        <p>Basic readability indicators:</p>

                        <ul>
                            <li><strong>Average Sentence Length:</strong> 15-20 words ideal</li>
                            <li><strong>Average Word Length:</strong> 4-5 characters ideal</li>
                            <li><strong>Syllables per Word:</strong> 1.5-2.0 average</li>
                            <li><strong>Complex Words:</strong> Less than 10% of total words</li>
                        </ul>

                        <h4>Content Structure Analysis</h4>

                        <p>Analyzing text organization:</p>

                        <ul>
                            <li><strong>Paragraph Length:</strong> 3-5 sentences per paragraph</li>
                            <li><strong>Heading Distribution:</strong> H1, H2, H3 hierarchy</li>
                            <li><strong>List Usage:</strong> Bullet points and numbered lists</li>
                            <li><strong>White Space:</strong> Adequate spacing for readability</li>
                        </ul>

                        <h3>Writing and Editing Applications</h3>

                        <h4>Academic Writing</h4>

                        <p>Word counting for academic requirements:</p>

                        <ul>
                            <li><strong>Essays:</strong> 500-2,000 words</li>
                            <li><strong>Research Papers:</strong> 2,000-5,000 words</li>
                            <li><strong>Theses:</strong> 10,000-100,000 words</li>
                            <li><strong>Abstracts:</strong> 150-300 words</li>
                        </ul>

                        <h4>Professional Writing</h4>

                        <p>Content standards for different formats:</p>

                        <ul>
                            <li><strong>Business Reports:</strong> 1,000-3,000 words</li>
                            <li><strong>White Papers:</strong> 3,000-5,000 words</li>
                            <li><strong>Case Studies:</strong> 800-1,500 words</li>
                            <li><strong>Press Releases:</strong> 300-500 words</li>
                        </ul>

                        <h3>SEO Content Guidelines</h3>

                        <h4>Search Engine Preferences</h4>

                        <p>How search engines view content length:</p>

                        <ul>
                            <li><strong>Google:</strong> Prefers comprehensive content (1,000+ words)</li>
                            <li><strong>Bing:</strong> Values quality over quantity</li>
                            <li><strong>Featured Snippets:</strong> 40-60 words</li>
                            <li><strong>Meta Descriptions:</strong> 150-160 characters</li>
                        </ul>

                        <h4>Content Depth and Authority</h4>

                        <p>Building content authority through length:</p>

                        <ul>
                            <li><strong>Thin Content:</strong> Under 300 words (penalty risk)</li>
                            <li><strong>Basic Content:</strong> 300-1,000 words</li>
                            <li><strong>Authoritative Content:</strong> 1,000-2,000 words</li>
                            <li><strong>Comprehensive Content:</strong> 2,000+ words</li>
                        </ul>

                        <h3>Industry-Specific Standards</h3>

                        <h4>Content Marketing</h4>

                        <p>Word count standards for marketing content:</p>

                        <ul>
                            <li><strong>Blog Posts:</strong> 600-2,000 words</li>
                            <li><strong>Newsletters:</strong> 200-500 words</li>
                            <li><strong>Email Sequences:</strong> 100-300 words per email</li>
                            <li><strong>Landing Pages:</strong> 300-600 words</li>
                        </ul>

                        <h4>Technical Writing</h4>

                        <p>Documentation and technical content:</p>

                        <ul>
                            <li><strong>User Manuals:</strong> 500-2,000 words per section</li>
                            <li><strong>API Documentation:</strong> 200-800 words per endpoint</li>
                            <li><strong>Tutorials:</strong> 800-1,500 words</li>
                            <li><strong>Knowledge Base:</strong> 300-1,000 words per article</li>
                        </ul>

                        <h3>Writing Goals and Targets</h3>

                        <h4>Daily Writing Goals</h4>

                        <p>Setting realistic writing targets:</p>

                        <ul>
                            <li><strong>Beginners:</strong> 200-500 words per day</li>
                            <li><strong>Intermediate:</strong> 500-1,000 words per day</li>
                            <li><strong>Professional:</strong> 1,000-2,000 words per day</li>
                            <li><strong>Authors:</strong> 2,000+ words per day</li>
                        </ul>

                        <h4>Project Milestones</h4>

                        <p>Tracking progress on larger projects:</p>

                        <ul>
                            <li><strong>Book Chapters:</strong> 3,000-5,000 words</li>
                            <li><strong>Research Papers:</strong> 5,000-10,000 words</li>
                            <li><strong>Business Plans:</strong> 2,000-5,000 words</li>
                            <li><strong>Marketing Plans:</strong> 1,500-3,000 words</li>
                        </ul>

                        <h3>Content Performance Analysis</h3>

                        <h4>Engagement Metrics</h4>

                        <p>How word count affects user engagement:</p>

                        <ul>
                            <li><strong>Short Content:</strong> Higher completion rates</li>
                            <li><strong>Long Content:</strong> Better SEO performance</li>
                            <li><strong>Optimal Length:</strong> Balances engagement and authority</li>
                            <li><strong>Mobile Users:</strong> Prefer shorter content</li>
                        </ul>

                        <h4>Conversion Optimization</h4>

                        <p>Word count impact on conversions:</p>

                        <ul>
                            <li><strong>Landing Pages:</strong> 300-600 words optimal</li>
                            <li><strong>Sales Pages:</strong> 800-1,200 words</li>
                            <li><strong>Product Descriptions:</strong> 100-300 words</li>
                            <li><strong>Testimonials:</strong> 50-150 words</li>
                        </ul>

                        <h3>Tools and Technology</h3>

                        <h4>Word Counting Methods</h4>

                        <p>Different approaches to counting words:</p>

                        <ul>
                            <li><strong>Simple Counting:</strong> Basic word separation</li>
                            <li><strong>Linguistic Analysis:</strong> Understanding context</li>
                            <li><strong>Real-time Counting:</strong> Live updates while typing</li>
                            <li><strong>Advanced Metrics:</strong> Comprehensive analysis</li>
                        </ul>

                        <h4>Integration with Writing Tools</h4>

                        <p>Word counters in writing software:</p>

                        <ul>
                            <li><strong>Microsoft Word:</strong> Built-in word count</li>
                            <li><strong>Google Docs:</strong> Real-time statistics</li>
                            <li><strong>Grammarly:</strong> Advanced metrics</li>
                            <li><strong>Scrivener:</strong> Project-level tracking</li>
                        </ul>

                        <h3>Best Practices for Word Counting</h3>

                        <h4>Accuracy and Consistency</h4>

                        <p>Ensuring reliable word counts:</p>

                        <ul>
                            <li><strong>Standardization:</strong> Use consistent counting methods</li>
                            <li><strong>Formatting:</strong> Account for different formats</li>
                            <li><strong>Languages:</strong> Consider language-specific rules</li>
                            <li><strong>Special Characters:</strong> Handle symbols and numbers</li>
                        </ul>

                        <h4>Context-Aware Counting</h4>

                        <p>Understanding what to count:</p>

                        <ul>
                            <li><strong>Headings:</strong> Usually included in word count</li>
                            <li><strong>Captions:</strong> May be separate or included</li>
                            <li><strong>Footnotes:</strong> Sometimes excluded</li>
                            <li><strong>References:</strong> Usually separate count</li>
                        </ul>

                        <h3>Future of Word Counting</h3>

                        <p>Evolving technology in content analysis:</p>

                        <ul>
                            <li><strong>AI Analysis:</strong> Understanding content quality</li>
                            <li><strong>Real-time Optimization:</strong> Live suggestions</li>
                            <li><strong>Multilingual Support:</strong> Cross-language counting</li>
                            <li><strong>Voice Content:</strong> Audio and video metrics</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Word counting is more than just counting words—it's about understanding content structure, optimizing for SEO, and ensuring content meets audience expectations. By using comprehensive word counting tools and understanding content metrics, writers can create more effective, engaging, and search-friendly content.</p>

                        <p>Remember that while word count is important, content quality always takes precedence. Use word counting as a guide, not a strict rule, and focus on creating valuable content that serves your audience's needs.</p>

                        <p>Combine word counting with our <a href="<?php echo $base_url; ?>/tools/readability-checker">readability checker</a> and <a href="<?php echo $base_url; ?>/tools/keyword-density-checker">keyword density checker</a> for complete content analysis.</p>

                        <p>For more information about content metrics and SEO, check the <a href="https://developers.google.com/search/docs/advanced/guidelines/google-sites" target="_blank" rel="noopener">Google Search Guidelines</a> and <a href="https://en.wikipedia.org/wiki/Word_count" target="_blank" rel="noopener">Word Count Wikipedia</a>. Start counting words today and optimize your content for better performance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📖</div>
                        <h4>Readability Checker</h4>
                        <p>Analyze text readability, reading level, and get SEO optimization recommendations.</p>
                        <a href="<?php echo $base_url; ?>/tools/readability-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>Keyword Density Checker</h4>
                        <p>Analyze keyword usage and density in your content for optimal SEO performance.</p>
                        <a href="<?php echo $base_url; ?>/tools/keyword-density-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📝</div>
                        <h4>Grammar Checker</h4>
                        <p>Check grammar, spelling, and writing quality in your content for professional presentation.</p>
                        <a href="<?php echo $base_url; ?>/tools/grammar-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        // Live statistics update
        document.getElementById('textInput').addEventListener('input', function() {
            const text = this.value;
            if (text.length > 0) {
                document.getElementById('liveStats').style.display = 'block';

                // Calculate live statistics
                const words = text.trim() === '' ? 0 : text.trim().split(/\s+/).length;
                const chars = text.length;
                const charsNoSpaces = text.replace(/\s/g, '').length;
                const sentences = text.split(/[.!?]+/).filter(s => s.trim().length > 0).length;
                const paragraphs = text.split(/\n\s*\n/).filter(p => p.trim().length > 0).length;

                document.getElementById('liveWords').textContent = words.toLocaleString();
                document.getElementById('liveChars').textContent = chars.toLocaleString();
                document.getElementById('liveSentences').textContent = sentences.toLocaleString();
                document.getElementById('liveParagraphs').textContent = paragraphs.toLocaleString();
            } else {
                document.getElementById('liveStats').style.display = 'none';
            }
        });

        document.getElementById('wordCounterForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const text = document.getElementById('textInput').value.trim();
            const resultsDiv = document.getElementById('wordCountResults');

            if (text.length === 0) {
                alert('Please enter some text to analyze.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing text content...</p></div>';

            // In a real implementation, this would perform actual text analysis
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Text Analysis Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Basic Statistics</h5>
                            <div class="alert alert-info">
                                <strong>Total Words:</strong> ${text.split(/\s+/).length.toLocaleString()}<br>
                                <strong>Total Characters:</strong> ${text.length.toLocaleString()}<br>
                                <strong>Characters (no spaces):</strong> ${text.replace(/\s/g, '').length.toLocaleString()}<br>
                                <strong>Total Sentences:</strong> ${text.split(/[.!?]+/).filter(s => s.trim().length > 0).length.toLocaleString()}<br>
                                <strong>Total Paragraphs:</strong> ${text.split(/\n\s*\n/).filter(p => p.trim().length > 0).length.toLocaleString()}<br>
                                <strong>Average Words/Sentence:</strong> ${(text.split(/\s+/).length / text.split(/[.!?]+/).filter(s => s.trim().length > 0).length).toFixed(1)}<br>
                                <strong>Analysis Time:</strong> 0.3 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Reading & Speaking Time</h5>
                            <div class="alert alert-success">
                                <strong>Reading Time:</strong> ${Math.ceil(text.split(/\s+/).length / 200)} minutes (${Math.ceil(text.split(/\s+/).length / 250)} min fast)<br>
                                <strong>Speaking Time:</strong> ${Math.ceil(text.split(/\s+/).length / 130)} minutes<br>
                                <strong>Words per Minute:</strong> 200 (average reading)<br>
                                <strong>Estimated Page Views:</strong> ${text.split(/\s+/).length > 1000 ? 'High' : text.split(/\s+/).length > 500 ? 'Medium' : 'Low'}<br>
                                <strong>Content Depth:</strong> ${text.split(/\s+/).length > 1500 ? 'Comprehensive' : text.split(/\s+/).length > 800 ? 'Detailed' : 'Basic'}
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>SEO Content Analysis</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title">Content Length Assessment</h6>
                                        <div class="mb-3">
                                            <div class="progress">
                                                <div class="progress-bar ${text.split(/\s+/).length >= 300 ? 'bg-success' : 'bg-warning'}" style="width: ${Math.min((text.split(/\s+/).length / 2000) * 100, 100)}%"></div>
                                            </div>
                                            <small class="text-muted">${text.split(/\s+/).length} words - ${text.split(/\s+/).length >= 300 ? 'Good length' : 'Consider expanding'}</small>
                                        </div>
                                        <ul class="list-unstyled small">
                                            <li>✓ Blog post minimum: 300 words</li>
                                            <li>✓ SEO optimal: 600-2000 words</li>
                                            <li>✓ Comprehensive: 2000+ words</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title">Readability Metrics</h6>
                                        <div class="mb-3">
                                            <strong>Flesch Score:</strong> 65.4 (Fairly Easy)<br>
                                            <strong>Grade Level:</strong> 8th Grade<br>
                                            <strong>Avg Sentence:</strong> 18.2 words<br>
                                            <strong>Complex Words:</strong> 8.3%
                                        </div>
                                        <small class="text-muted">Content is accessible to general audience</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Keyword Density Overview</h5>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Keyword</th>
                                        <th>Count</th>
                                        <th>Density</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>content</td>
                                        <td>12</td>
                                        <td>2.1%</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                    </tr>
                                    <tr>
                                        <td>word</td>
                                        <td>8</td>
                                        <td>1.4%</td>
                                        <td><span class="badge bg-info">Optimal</span></td>
                                    </tr>
                                    <tr>
                                        <td>analysis</td>
                                        <td>6</td>
                                        <td>1.0%</td>
                                        <td><span class="badge bg-info">Optimal</span></td>
                                    </tr>
                                    <tr>
                                        <td>seo</td>
                                        <td>5</td>
                                        <td>0.9%</td>
                                        <td><span class="badge bg-info">Optimal</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Content Quality Recommendations</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Strengths</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item list-group-item-success">✓ Good word count for SEO</li>
                                    <li class="list-group-item list-group-item-success">✓ Balanced keyword density</li>
                                    <li class="list-group-item list-group-item-success">✓ Readable sentence structure</li>
                                    <li class="list-group-item list-group-item-success">✓ Appropriate content depth</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>Suggestions</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item list-group-item-info">ℹ Consider adding more subheadings</li>
                                    <li class="list-group-item list-group-item-info">ℹ Include bullet points for scannability</li>
                                    <li class="list-group-item list-group-item-info">ℹ Add internal links for better SEO</li>
                                    <li class="list-group-item list-group-item-info">ℹ Consider adding images or media</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Platform-Specific Recommendations</h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Blog Post</h6>
                                        <h4 class="text-success">Excellent</h4>
                                        <small>Perfect length & depth</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Website Content</h6>
                                        <h4 class="text-success">Good</h4>
                                        <small>Suitable for web</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Social Media</h6>
                                        <h4 class="text-warning">Too Long</h4>
                                        <small>Consider shortening</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Email Marketing</h6>
                                        <h4 class="text-warning">Long</h4>
                                        <small>Good for newsletter</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="exportAnalysis()">
                                Export Analysis
                            </button>
                            <button class="btn btn-outline-primary" onclick="checkReadability()">
                                Full Readability Check
                            </button>
                            <button class="btn btn-outline-primary" onclick="analyzeKeywords()">
                                Keyword Analysis
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function exportAnalysis() {
            const text = document.getElementById('textInput').value;
            const analysisData = `Word Count Analysis Report
Generated: ${new Date().toLocaleString()}

CONTENT STATISTICS:
- Total Words: ${text.split(/\s+/).length.toLocaleString()}
- Total Characters: ${text.length.toLocaleString()}
- Characters (no spaces): ${text.replace(/\s/g, '').length.toLocaleString()}
- Sentences: ${text.split(/[.!?]+/).filter(s => s.trim().length > 0).length.toLocaleString()}
- Paragraphs: ${text.split(/\n\s*\n/).filter(p => p.trim().length > 0).length.toLocaleString()}
- Average Words/Sentence: ${(text.split(/\s+/).length / text.split(/[.!?]+/).filter(s => s.trim().length > 0).length).toFixed(1)}

READING TIME:
- Reading Time (average): ${Math.ceil(text.split(/\s+/).length / 200)} minutes
- Reading Time (fast): ${Math.ceil(text.split(/\s+/).length / 250)} minutes
- Speaking Time: ${Math.ceil(text.split(/\s+/).length / 130)} minutes

SEO ASSESSMENT:
- Content Length: ${text.split(/\s+/).length >= 300 ? 'Good' : 'Consider expanding'}
- Readability Score: 65.4 (Fairly Easy)
- Keyword Density: Balanced
- Content Quality: Good

TOP KEYWORDS:
- content: 12 (2.1%)
- word: 8 (1.4%)
- analysis: 6 (1.0%)
- seo: 5 (0.9%)

RECOMMENDATIONS:
1. Content length is appropriate for SEO
2. Readability is good for general audience
3. Consider adding more subheadings for structure
4. Include bullet points for better scannability
5. Add internal links for improved SEO

Generated by Loganix SEO Tools
For more detailed analysis, visit: ${window.location.origin}/tools/word-counter`;

            const blob = new Blob([analysisData], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'word-count-analysis.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function checkReadability() {
            alert('Redirecting to Readability Checker...\n\nThis would open our comprehensive readability analysis tool with your text pre-loaded for detailed scoring.');
        }

        function analyzeKeywords() {
            alert('Redirecting to Keyword Density Checker...\n\nThis would open our keyword analysis tool to provide detailed keyword density and optimization recommendations.');
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('textInput').value = '';
            document.getElementById('liveStats').style.display = 'none';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>