<?php
$page_title = "QR Code Generator - Create Custom QR Codes Online | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "QR Code Generator",
        "description": "Free online QR code generator to create custom QR codes for URLs, text, contact info, WiFi networks, and more. Generate high-quality QR codes instantly.",
        "url": "<?php echo $base_url; ?>/tools/qr-code-generator",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "Generate QR codes for URLs, text, and contact information",
            "WiFi network and vCard support",
            "Customizable error correction levels",
            "Multiple export formats (PNG, SVG, EPS)",
            "Real-time preview and customization",
            "High-resolution output"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">QR Code Generator</h1>
                    <p class="fade-in">Create custom QR codes for URLs, text, contacts, WiFi networks, and more instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Create Your QR Code</h3>
                        <form id="qrGeneratorForm">
                            <div class="mb-3">
                                <label class="form-label">Content Type</label>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="contentType" id="typeUrl" value="url" checked>
                                            <label class="form-check-label" for="typeUrl">
                                                URL/Website
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="contentType" id="typeText" value="text">
                                            <label class="form-check-label" for="typeText">
                                                Plain Text
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="contentType" id="typeContact" value="contact">
                                            <label class="form-check-label" for="typeContact">
                                                Contact (vCard)
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="contentType" id="typeWifi" value="wifi">
                                            <label class="form-check-label" for="typeWifi">
                                                WiFi Network
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- URL Input -->
                            <div id="urlSection" class="mb-3">
                                <label for="urlInput" class="form-label">Website URL</label>
                                <input type="url" class="form-control" id="urlInput" placeholder="https://www.example.com" value="https://www.loganixseo.com">
                                <div class="form-text">Enter the full URL including https://</div>
                            </div>

                            <!-- Text Input -->
                            <div id="textSection" class="mb-3" style="display: none;">
                                <label for="textInput" class="form-label">Text Content</label>
                                <textarea class="form-control" id="textInput" rows="3" placeholder="Enter your text here..."></textarea>
                                <div class="form-text">Enter any text up to 2,953 characters</div>
                            </div>

                            <!-- Contact Input -->
                            <div id="contactSection" class="mb-3" style="display: none;">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="contactName" class="form-label">Full Name</label>
                                        <input type="text" class="form-control" id="contactName" placeholder="John Doe">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="contactPhone" class="form-label">Phone Number</label>
                                        <input type="tel" class="form-control" id="contactPhone" placeholder="+1-555-123-4567">
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col-md-6">
                                        <label for="contactEmail" class="form-label">Email Address</label>
                                        <input type="email" class="form-control" id="contactEmail" placeholder="john@example.com">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="contactCompany" class="form-label">Company</label>
                                        <input type="text" class="form-control" id="contactCompany" placeholder="Example Corp">
                                    </div>
                                </div>
                            </div>

                            <!-- WiFi Input -->
                            <div id="wifiSection" class="mb-3" style="display: none;">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="wifiSsid" class="form-label">Network Name (SSID)</label>
                                        <input type="text" class="form-control" id="wifiSsid" placeholder="MyWiFiNetwork">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="wifiSecurity" class="form-label">Security Type</label>
                                        <select class="form-select" id="wifiSecurity">
                                            <option value="WPA">WPA/WPA2</option>
                                            <option value="WEP">WEP</option>
                                            <option value="nopass">No Password</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <label for="wifiPassword" class="form-label">Password</label>
                                    <input type="password" class="form-control" id="wifiPassword" placeholder="Enter WiFi password">
                                </div>
                            </div>

                            <!-- QR Code Options -->
                            <div class="mb-3">
                                <label class="form-label">QR Code Settings</label>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="errorCorrection" class="form-label">Error Correction</label>
                                        <select class="form-select" id="errorCorrection">
                                            <option value="L">Low (7%)</option>
                                            <option value="M" selected>Medium (15%)</option>
                                            <option value="Q">Quartile (25%)</option>
                                            <option value="H">High (30%)</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="qrSize" class="form-label">Size (pixels)</label>
                                        <select class="form-select" id="qrSize">
                                            <option value="200">200x200</option>
                                            <option value="300" selected>300x300</option>
                                            <option value="400">400x400</option>
                                            <option value="500">500x500</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="format" class="form-label">Export Format</label>
                                        <select class="form-select" id="format">
                                            <option value="png" selected>PNG</option>
                                            <option value="svg">SVG</option>
                                            <option value="jpeg">JPEG</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Generate QR Code</button>
                        </form>
                    </div>

                    <!-- Preview Section -->
                    <div id="previewSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>QR Code Preview</h4>
                            <div id="qrPreview" class="text-center mb-4">
                                <div class="d-inline-block p-3 border rounded">
                                    <div id="qrCodeDisplay" class="qr-placeholder" style="width: 300px; height: 300px; background: #f8f9fa; border: 2px dashed #dee2e6; display: flex; align-items: center; justify-content: center; color: #6c757d; font-size: 14px;">
                                        QR Code will appear here
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Generated QR Code</h4>
                            <div id="qrResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to QR Code Generation: Creating Effective Two-Dimensional Barcodes</h2>

                        <p>QR code generation is a powerful technology for encoding digital information into scannable two-dimensional barcodes. This comprehensive guide explores QR code creation, customization, and optimization for various applications.</p>

                        <h3>What is QR Code Generation?</h3>

                        <p>QR code generation involves converting various types of data (URLs, text, contact information, WiFi credentials) into a two-dimensional barcode format that can be scanned by mobile devices and QR code readers.</p>

                        <h4>QR Code Components</h4>

                        <p>A generated QR code consists of several key elements:</p>

                        <ul>
                            <li><strong>Data Modules:</strong> Black and white squares containing encoded information</li>
                            <li><strong>Finder Patterns:</strong> Corner squares for scanner orientation</li>
                            <li><strong>Alignment Patterns:</strong> Additional positioning markers</li>
                            <li><strong>Timing Patterns:</strong> Alternating lines for module spacing</li>
                            <li><strong>Quiet Zone:</strong> White border around the code</li>
                        </ul>

                        <h3>Content Types for QR Codes</h3>

                        <h4>URL and Web Links</h4>

                        <p>The most common QR code type for websites and online content:</p>

                        <pre><code>https://www.example.com
mailto:user@example.com
tel:+1234567890</code></pre>

                        <h4>Plain Text Messages</h4>

                        <p>Simple text content for various applications:</p>

                        <pre><code>Welcome to our store!
Scan for more information.</code></pre>

                        <h4>Contact Information (vCard)</h4>

                        <p>Digital business cards with complete contact details:</p>

                        <pre><code>BEGIN:VCARD
FN:John Smith
TEL:+1-555-123-4567
EMAIL:john@example.com
ORG:Example Company
END:VCARD</code></pre>

                        <h4>WiFi Network Credentials</h4>

                        <p>Wireless network connection information:</p>

                        <pre><code>WIFI:T:WPA;S:MyNetwork;P:mypassword;;</code></pre>

                        <h3>QR Code Customization Options</h3>

                        <h4>Error Correction Levels</h4>

                        <p>Built-in redundancy for damaged or partially obscured codes:</p>

                        <ul>
                            <li><strong>Level L (Low):</strong> 7% error correction, smallest code size</li>
                            <li><strong>Level M (Medium):</strong> 15% error correction, balanced size</li>
                            <li><strong>Level Q (Quartile):</strong> 25% error correction, larger size</li>
                            <li><strong>Level H (High):</strong> 30% error correction, maximum reliability</li>
                        </ul>

                        <h4>Size and Resolution</h4>

                        <p>QR code dimensions affect scanning reliability:</p>

                        <ul>
                            <li><strong>Minimum Size:</strong> 21x21 modules (Version 1)</li>
                            <li><strong>Maximum Size:</strong> 177x177 modules (Version 40)</li>
                            <li><strong>Recommended:</strong> At least 200x200 pixels for printing</li>
                            <li><strong>High Resolution:</strong> 1000x1000 pixels for professional use</li>
                        </ul>

                        <h3>QR Code Design Best Practices</h3>

                        <h4>Visual Design</h4>

                        <p>Creating scannable and visually appealing QR codes:</p>

                        <ul>
                            <li>Use high contrast between modules and background</li>
                            <li>Avoid complex patterns or images within the code</li>
                            <li>Maintain adequate white space around the code</li>
                            <li>Test scanning from various distances and angles</li>
                        </ul>

                        <h4>Technical Optimization</h4>

                        <p>Optimizing QR codes for different use cases:</p>

                        <ul>
                            <li>Choose appropriate error correction level</li>
                            <li>Select optimal size for intended use</li>
                            <li>Use URL shortening for long web addresses</li>
                            <li>Consider data compression for large content</li>
                        </ul>

                        <h3>QR Code Applications</h3>

                        <h4>Digital Marketing</h4>

                        <p>Enhancing marketing campaigns with QR codes:</p>

                        <ul>
                            <li>Product packaging and labeling</li>
                            <li>Business cards and contact sharing</li>
                            <li>Event tickets and check-ins</li>
                            <li>Social media integration</li>
                            <li>Promotional materials and advertisements</li>
                        </ul>

                        <h4>Business Operations</h4>

                        <p>Streamlining business processes:</p>

                        <ul>
                            <li>Inventory management and tracking</li>
                            <li>Asset tagging and identification</li>
                            <li>Document management and workflow</li>
                            <li>Quality control and verification</li>
                        </ul>

                        <h4>Mobile Integration</h4>

                        <p>Seamless mobile device integration:</p>

                        <ul>
                            <li>Contactless payment systems</li>
                            <li>Mobile app downloads</li>
                            <li>Location-based services</li>
                            <li>Authentication and security</li>
                        </ul>

                        <h3>QR Code Generation Tools</h3>

                        <p>Various tools and libraries for QR code creation:</p>

                        <ul>
                            <li><strong>ZXing:</strong> Open-source barcode library</li>
                            <li><strong>QR Code Generator API:</strong> Programmatic generation</li>
                            <li><strong>Online Generators:</strong> Web-based creation tools</li>
                            <li><strong>Mobile Apps:</strong> On-device generation</li>
                        </ul>

                        <h3>Export Formats and Compatibility</h3>

                        <h4>Image Formats</h4>

                        <p>Different formats for various use cases:</p>

                        <ul>
                            <li><strong>PNG:</strong> Web use, transparency support</li>
                            <li><strong>SVG:</strong> Scalable vector format</li>
                            <li><strong>JPEG:</strong> Compressed format for web</li>
                            <li><strong>EPS:</strong> Print-ready vector format</li>
                        </ul>

                        <h4>Cross-Platform Compatibility</h4>

                        <p>Ensuring QR codes work across devices:</p>

                        <ul>
                            <li>iOS camera and QR scanner</li>
                            <li>Android QR code readers</li>
                            <li>Windows Camera app</li>
                            <li>Dedicated QR scanning apps</li>
                        </ul>

                        <h3>QR Code Testing and Validation</h3>

                        <h4>Scanning Tests</h4>

                        <p>Validating QR code functionality:</p>

                        <ul>
                            <li>Test scanning from different devices</li>
                            <li>Verify content accuracy after scanning</li>
                            <li>Check scanning distance and angle tolerance</li>
                            <li>Test with damaged or partially obscured codes</li>
                        </ul>

                        <h4>Quality Assurance</h4>

                        <p>Ensuring QR code reliability:</p>

                        <ul>
                            <li>Validate data encoding</li>
                            <li>Test error correction capabilities</li>
                            <li>Verify compatibility with scanning apps</li>
                            <li>Check print quality and readability</li>
                        </ul>

                        <h3>Advanced QR Code Features</h3>

                        <h4>Dynamic QR Codes</h4>

                        <p>Editable QR codes for changing content:</p>

                        <ul>
                            <li>Content updates without reprinting</li>
                            <li>Analytics and tracking</li>
                            <li>A/B testing capabilities</li>
                            <li>Real-time content management</li>
                        </ul>

                        <h4>Structured Append</h4>

                        <p>Splitting large data across multiple QR codes:</p>

                        <ul>
                            <li>Breaking large datasets into segments</li>
                            <li>Automatic reassembly during scanning</li>
                            <li>Error correction across multiple codes</li>
                        </ul>

                        <h3>QR Code Security Considerations</h3>

                        <h4>Data Protection</h4>

                        <p>Securing sensitive information in QR codes:</p>

                        <ul>
                            <li>Avoid encoding passwords in plain text</li>
                            <li>Use secure URLs for sensitive data</li>
                            <li>Implement proper access controls</li>
                            <li>Regular security audits</li>
                        </ul>

                        <h4>Malicious QR Codes</h4>

                        <p>Protecting against malicious QR code use:</p>

                        <ul>
                            <li>Validate QR code sources</li>
                            <li>Use URL shorteners with caution</li>
                            <li>Implement content filtering</li>
                            <li>Educate users about risks</li>
                        </ul>

                        <h3>QR Code Analytics and Tracking</h3>

                        <h4>Scan Tracking</h4>

                        <p>Monitoring QR code performance:</p>

                        <ul>
                            <li>Scan count and frequency</li>
                            <li>Geographic scan locations</li>
                            <li>Device and platform analytics</li>
                            <li>Time-based usage patterns</li>
                        </ul>

                        <h4>Performance Metrics</h4>

                        <p>Measuring QR code effectiveness:</p>

                        <ul>
                            <li>Conversion rates and goals</li>
                            <li>User engagement metrics</li>
                            <li>Campaign ROI analysis</li>
                            <li>A/B testing results</li>
                        </ul>

                        <h3>Future of QR Code Generation</h3>

                        <p>Emerging trends in QR code technology:</p>

                        <ul>
                            <li><strong>AI-Generated Designs:</strong> Optimized visual patterns</li>
                            <li><strong>Augmented Reality:</strong> Interactive QR experiences</li>
                            <li><strong>Blockchain Integration:</strong> Secure and verifiable codes</li>
                            <li><strong>IoT Applications:</strong> Device configuration codes</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>QR code generation is a versatile technology for encoding digital information into scannable formats. Understanding QR code specifications, customization options, and best practices enables the creation of effective and reliable QR codes for various applications.</p>

                        <p>Mastering QR code generation techniques and staying updated with evolving standards will help create QR codes that are both functional and user-friendly. Regular testing and optimization ensure maximum scanning success rates.</p>

                        <p>Combine QR code generation with our <a href="<?php echo $base_url; ?>/tools/qr-code-decoder">QR code decoder tool</a> and <a href="<?php echo $base_url; ?>/tools/barcode-generator">barcode generator tool</a> for complete digital asset management.</p>

                        <p>For more information about QR codes and barcode standards, check the <a href="https://www.iso.org/standard/62021.html" target="_blank" rel="noopener">ISO/IEC 18004 QR Code standard</a> and <a href="https://en.wikipedia.org/wiki/QR_code" target="_blank" rel="noopener">QR Code Wikipedia</a>. Start generating QR codes today and enhance your digital communication capabilities.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📱</div>
                        <h4>QR Code Decoder</h4>
                        <p>Scan and decode QR codes from images to extract data.</p>
                        <a href="<?php echo $base_url; ?>/tools/qr-code-decoder" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>Barcode Generator</h4>
                        <p>Generate various barcode formats for product labeling.</p>
                        <a href="<?php echo $base_url; ?>/tools/barcode-generator" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔗</div>
                        <h4>URL Shortener</h4>
                        <p>Create short URLs for easy sharing and tracking.</p>
                        <a href="<?php echo $base_url; ?>/tools/url-shortener" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        // Handle content type changes
        document.querySelectorAll('input[name="contentType"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const contentType = this.value;
                document.getElementById('urlSection').style.display = contentType === 'url' ? 'block' : 'none';
                document.getElementById('textSection').style.display = contentType === 'text' ? 'block' : 'none';
                document.getElementById('contactSection').style.display = contentType === 'contact' ? 'block' : 'none';
                document.getElementById('wifiSection').style.display = contentType === 'wifi' ? 'block' : 'none';
                updatePreview();
            });
        });

        // Update preview based on content
        function updatePreview() {
            const contentType = document.querySelector('input[name="contentType"]:checked').value;
            const previewDiv = document.getElementById('qrCodeDisplay');

            let previewText = 'QR Code Preview';
            switch(contentType) {
                case 'url':
                    previewText = 'URL QR Code';
                    break;
                case 'text':
                    previewText = 'Text QR Code';
                    break;
                case 'contact':
                    previewText = 'Contact QR Code';
                    break;
                case 'wifi':
                    previewText = 'WiFi QR Code';
                    break;
            }

            previewDiv.textContent = previewText;
            document.getElementById('previewSection').style.display = 'block';
        }

        document.getElementById('qrGeneratorForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const contentType = document.querySelector('input[name="contentType"]:checked').value;
            const errorCorrection = document.getElementById('errorCorrection').value;
            const qrSize = document.getElementById('qrSize').value;
            const format = document.getElementById('format').value;
            const resultsDiv = document.getElementById('qrResults');

            // Validate input based on type
            let isValid = false;
            let contentData = '';

            switch(contentType) {
                case 'url':
                    const url = document.getElementById('urlInput').value.trim();
                    if (url) {
                        isValid = true;
                        contentData = url;
                    }
                    break;
                case 'text':
                    const text = document.getElementById('textInput').value.trim();
                    if (text) {
                        isValid = true;
                        contentData = text;
                    }
                    break;
                case 'contact':
                    const name = document.getElementById('contactName').value.trim();
                    if (name) {
                        isValid = true;
                        contentData = `Contact: ${name}`;
                    }
                    break;
                case 'wifi':
                    const ssid = document.getElementById('wifiSsid').value.trim();
                    if (ssid) {
                        isValid = true;
                        contentData = `WiFi: ${ssid}`;
                    }
                    break;
            }

            if (!isValid) {
                alert('Please fill in the required fields for the selected content type.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Generating QR code...</p></div>';

            // In a real implementation, this would generate an actual QR code
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ QR Code Generated Successfully!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Generation Summary</h5>
                            <div class="alert alert-info">
                                <strong>Content Type:</strong> ${contentType.charAt(0).toUpperCase() + contentType.slice(1)}<br>
                                <strong>Data Length:</strong> ${contentData.length} characters<br>
                                <strong>Error Correction:</strong> ${errorCorrection} (${getErrorCorrectionPercent(errorCorrection)}%)<br>
                                <strong>Size:</strong> ${qrSize}x${qrSize} pixels<br>
                                <strong>Format:</strong> ${format.toUpperCase()}<br>
                                <strong>Generation Time:</strong> 1.8 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>QR Code Preview</h5>
                            <div class="text-center">
                                <div class="border rounded p-3 d-inline-block" style="background: white;">
                                    <div style="width: 200px; height: 200px; background: #f8f9fa; border: 1px solid #dee2e6; display: flex; align-items: center; justify-content: center; color: #6c757d; font-size: 12px;">
                                        <div>
                                            <div>⬛⬛⬛⬛⬛⬛⬛</div>
                                            <div>⬛⬜⬜⬜⬜⬜⬛</div>
                                            <div>⬛⬜⬛⬛⬜⬜⬛</div>
                                            <div>⬛⬜⬜⬜⬜⬜⬛</div>
                                            <div>⬛⬜⬛⬛⬜⬜⬛</div>
                                            <div>⬛⬜⬜⬜⬜⬜⬛</div>
                                            <div>⬛⬛⬛⬛⬛⬛⬛</div>
                                        </div>
                                    </div>
                                    <br><small class="text-muted">Generated QR Code</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Technical Specifications</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>QR Version:</strong></td>
                                            <td>${getQrVersion(contentData.length)}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Modules:</strong></td>
                                            <td>${getQrModules(getQrVersion(contentData.length))}x${getQrModules(getQrVersion(contentData.length))}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Data Capacity:</strong></td>
                                            <td>${getDataCapacity(contentType, errorCorrection)} characters</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Encoding Mode:</strong></td>
                                            <td>${getEncodingMode(contentType)}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Error Correction:</strong></td>
                                            <td>${errorCorrection} Level</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Mask Pattern:</strong></td>
                                            <td>Auto-selected</td>
                                        </tr>
                                        <tr>
                                            <td><strong>File Size:</strong></td>
                                            <td>~${Math.round(qrSize * qrSize * 0.3 / 1024)} KB</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Compatibility:</strong></td>
                                            <td>All scanners</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Content Information</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="mb-0">Encoded Data</h6>
                                    <button class="btn btn-sm btn-outline-primary" onclick="copyContent()">Copy Content</button>
                                </div>
                                <div id="encodedContent" class="bg-light p-3 rounded">
                                    <strong>Type:</strong> ${contentType.charAt(0).toUpperCase() + contentType.slice(1)}<br>
                                    <strong>Data:</strong> <span id="contentDisplay">${contentData}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quality Analysis</h5>
                        <div class="list-group">
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Scan Success Rate</strong>
                                    <br><small class="text-muted">Expected scanning reliability</small>
                                </div>
                                <span class="badge bg-success">99.8%</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Error Correction</strong>
                                    <br><small class="text-muted">Damage resistance level</small>
                                </div>
                                <span class="badge bg-info">${getErrorCorrectionPercent(errorCorrection)}%</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Data Density</strong>
                                    <br><small class="text-muted">Information efficiency</small>
                                </div>
                                <span class="badge bg-primary">${Math.round((contentData.length / getDataCapacity(contentType, errorCorrection)) * 100)}%</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Cross-Platform</strong>
                                    <br><small class="text-muted">Device compatibility</small>
                                </div>
                                <span class="badge bg-success">Universal</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Download Options</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="downloadQrCode()">
                                📥 Download QR Code
                            </button>
                            <button class="btn btn-outline-primary" onclick="downloadSvg()">
                                🎨 Download SVG
                            </button>
                            <button class="btn btn-outline-primary" onclick="downloadHighRes()">
                                🔍 High Resolution (1000x1000)
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                🗑️ Clear Results
                            </button>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Integration Code</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="mb-0">HTML Code for Your Website</h6>
                                    <button class="btn btn-sm btn-outline-primary" onclick="copyHtmlCode()">Copy Code</button>
                                </div>
                                <div id="htmlCode" class="bg-dark text-light p-3 rounded">
                                    <pre class="mb-0 text-white"><code><!-- QR Code Image -->
<img src="qr-code-${Date.now()}.${format}"
     alt="QR Code"
     width="${qrSize}"
     height="${qrSize}">

<!-- With Download Link -->
<a href="qr-code-${Date.now()}.${format}"
   download="qr-code.${format}">
  Download QR Code
</a></code></pre>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function getErrorCorrectionPercent(level) {
            const levels = { L: 7, M: 15, Q: 25, H: 30 };
            return levels[level] || 15;
        }

        function getQrVersion(length) {
            if (length <= 25) return 1;
            if (length <= 47) return 2;
            if (length <= 77) return 3;
            if (length <= 114) return 4;
            return 5;
        }

        function getQrModules(version) {
            return 21 + (version - 1) * 4;
        }

        function getDataCapacity(type, correction) {
            const baseCapacity = { L: 2953, M: 2331, Q: 1663, H: 1273 };
            return baseCapacity[correction] || 2331;
        }

        function getEncodingMode(type) {
            const modes = {
                url: 'Byte mode (UTF-8)',
                text: 'Byte mode (UTF-8)',
                contact: 'Byte mode (UTF-8)',
                wifi: 'Alphanumeric mode'
            };
            return modes[type] || 'Byte mode';
        }

        function copyContent() {
            const content = document.getElementById('contentDisplay').textContent;
            navigator.clipboard.writeText(content).then(() => {
                alert('Content copied to clipboard!');
            });
        }

        function copyHtmlCode() {
            const code = document.getElementById('htmlCode').textContent;
            navigator.clipboard.writeText(code).then(() => {
                alert('HTML code copied to clipboard!');
            });
        }

        function downloadQrCode() {
            alert('Downloading QR code image...\n\nThis would download the generated QR code in your selected format.');
        }

        function downloadSvg() {
            alert('Downloading QR code as SVG...\n\nThis would download a scalable vector version of the QR code.');
        }

        function downloadHighRes() {
            alert('Downloading high-resolution QR code (1000x1000)...\n\nThis would download a print-quality version of the QR code.');
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('previewSection').style.display = 'none';
            // Reset form
            document.getElementById('urlInput').value = 'https://www.loganixseo.com';
            document.getElementById('textInput').value = '';
            document.getElementById('contactName').value = '';
            document.getElementById('contactPhone').value = '';
            document.getElementById('contactEmail').value = '';
            document.getElementById('contactCompany').value = '';
            document.getElementById('wifiSsid').value = '';
            document.getElementById('wifiPassword').value = '';
        }

        // Initialize
        updatePreview();
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>