<?php
$page_title = "QR Code Decoder - Scan & Decode QR Codes Online | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "QR Code Decoder",
        "description": "Free online QR code decoder tool to scan and decode QR codes from images. Extract URLs, text, contact info, and more instantly for digital marketing and data processing.",
        "url": "<?php echo $base_url; ?>/tools/qr-code-decoder",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "QR code image upload and scanning",
            "Multiple data format support (URL, text, contact, WiFi)",
            "Real-time decoding with instant results",
            "Bulk QR code processing",
            "Error correction and damaged code recovery",
            "Mobile-friendly camera scanning"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">QR Code Decoder</h1>
                    <p class="fade-in">Scan and decode QR codes from images to extract URLs, text, contacts, and more instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Upload QR Code Image</h3>
                        <form id="qrDecoderForm">
                            <div class="mb-3">
                                <label for="qrImage" class="form-label">QR Code Image</label>
                                <input type="file" class="form-control" id="qrImage" accept="image/*" required>
                                <div class="form-text">Upload a PNG, JPG, or GIF image containing a QR code (max 10MB)</div>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="tryHarder" checked>
                                    <label class="form-check-label" for="tryHarder">
                                        Enhanced scanning (slower but more accurate for damaged codes)
                                    </label>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="multipleCodes" checked>
                                    <label class="form-check-label" for="multipleCodes">
                                        Scan for multiple QR codes in the image
                                    </label>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Decode QR Code</button>
                        </form>
                    </div>

                    <!-- Camera Section (Mobile) -->
                    <div class="service-card p-4 mt-4 d-none d-md-block">
                        <h4>Mobile Camera Scanning</h4>
                        <p>Use your mobile device camera to scan QR codes directly:</p>
                        <button class="btn btn-outline-primary" onclick="startCameraScan()" id="cameraBtn">
                            📱 Open Camera Scanner
                        </button>
                        <div id="cameraContainer" class="mt-3" style="display: none;">
                            <video id="cameraVideo" width="100%" height="300" style="border: 1px solid #ddd;"></video>
                            <br>
                            <button class="btn btn-success mt-2" onclick="captureAndDecode()">📸 Capture & Decode</button>
                            <button class="btn btn-secondary mt-2 ms-2" onclick="stopCamera()">❌ Stop Camera</button>
                        </div>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>QR Code Decoding Results</h4>
                            <div id="qrResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to QR Code Decoding: Scanning and Extracting Digital Information</h2>

                        <p>QR code decoding is a fundamental technology for extracting digital information from two-dimensional barcodes. This comprehensive guide explores QR code technology, decoding processes, and practical applications for digital marketing and data processing.</p>

                        <h3>What is a QR Code?</h3>

                        <p>QR (Quick Response) codes are two-dimensional barcodes that can store various types of data including text, URLs, contact information, and more. They were invented in 1994 by Denso Wave, a Japanese company, and have become ubiquitous in modern digital communication.</p>

                        <h4>QR Code Structure</h4>

                        <p>QR codes consist of black squares arranged on a white background in a square grid pattern:</p>

                        <ul>
                            <li><strong>Finder Patterns:</strong> Three corner squares for orientation</li>
                            <li><strong>Timing Patterns:</strong> Alternating black/white squares for alignment</li>
                            <li><strong>Alignment Patterns:</strong> Smaller squares for distortion correction</li>
                            <li><strong>Data Area:</strong> Encoded information in the center</li>
                            <li><strong>Quiet Zone:</strong> White border around the code</li>
                        </ul>

                        <h3>How QR Code Decoding Works</h3>

                        <h4>Scanning Process</h4>

                        <p>The decoding process involves several technical steps:</p>

                        <ul>
                            <li><strong>Image Capture:</strong> Camera or scanner captures the QR code image</li>
                            <li><strong>Preprocessing:</strong> Image enhancement and noise reduction</li>
                            <li><strong>Localization:</strong> Finding finder patterns and determining orientation</li>
                            <li><strong>Extraction:</strong> Sampling the data grid from the image</li>
                            <li><strong>Error Correction:</strong> Using Reed-Solomon error correction</li>
                            <li><strong>Decoding:</strong> Converting binary data to original format</li>
                        </ul>

                        <h4>Error Correction Levels</h4>

                        <p>QR codes include built-in error correction capabilities:</p>

                        <ul>
                            <li><strong>Level L (Low):</strong> 7% error correction capacity</li>
                            <li><strong>Level M (Medium):</strong> 15% error correction capacity</li>
                            <li><strong>Level Q (Quartile):</strong> 25% error correction capacity</li>
                            <li><strong>Level H (High):</strong> 30% error correction capacity</li>
                        </ul>

                        <h3>QR Code Data Types</h3>

                        <h4>Standard Formats</h4>

                        <p>QR codes can encode various types of information:</p>

                        <h5>URL/Website Links</h5>

                        <p>The most common QR code type containing web addresses:</p>

                        <pre><code>https://www.example.com
mailto:user@example.com
tel:+1234567890</code></pre>

                        <h5>Plain Text</h5>

                        <p>Simple text messages and notes:</p>

                        <pre><code>Hello, World!
This is a QR code message.</code></pre>

                        <h5>Contact Information (vCard)</h5>

                        <p>Digital business cards with contact details:</p>

                        <pre><code>BEGIN:VCARD
FN:John Doe
TEL:+1234567890
EMAIL:john@example.com
END:VCARD</code></pre>

                        <h5>WiFi Network Credentials</h5>

                        <p>Wireless network connection information:</p>

                        <pre><code>WIFI:T:WPA;S:MyNetwork;P:password;;</code></pre>

                        <h3>QR Code Applications</h3>

                        <h4>Digital Marketing</h4>

                        <p>QR codes enhance marketing campaigns:</p>

                        <ul>
                            <li>Product packaging and labeling</li>
                            <li>Business cards and contact sharing</li>
                            <li>Event tickets and check-ins</li>
                            <li>Promotional materials and advertisements</li>
                            <li>Social media integration</li>
                        </ul>

                        <h4>Business Operations</h4>

                        <p>Streamlining business processes:</p>

                        <ul>
                            <li>Inventory management and tracking</li>
                            <li>Asset tagging and identification</li>
                            <li>Document management and archiving</li>
                            <li>Quality control and verification</li>
                        </ul>

                        <h4>Mobile Payments</h4>

                        <p>Facilitating digital transactions:</p>

                        <ul>
                            <li>Contactless payment systems</li>
                            <li>Invoice and receipt generation</li>
                            <li>Loyalty program integration</li>
                            <li>Cryptocurrency wallet addresses</li>
                        </ul>

                        <h3>QR Code Standards and Specifications</h3>

                        <h4>ISO/IEC 18004</h4>

                        <p>The international standard for QR codes:</p>

                        <ul>
                            <li>Defines QR code structure and encoding</li>
                            <li>Specifies error correction algorithms</li>
                            <li>Standardizes data formats and capacities</li>
                            <li>Ensures interoperability across devices</li>
                        </ul>

                        <h4>Character Encoding</h4>

                        <p>QR codes support multiple character sets:</p>

                        <ul>
                            <li><strong>Numeric:</strong> 0-9 (up to 7,089 characters)</li>
                            <li><strong>Alphanumeric:</strong> A-Z, 0-9, and symbols (up to 4,296 characters)</li>
                            <li><strong>Binary/Byte:</strong> Any 8-bit data (up to 2,953 bytes)</li>
                            <li><strong>Kanji/Kana:</strong> Japanese characters (up to 1,817 characters)</li>
                        </ul>

                        <h3>QR Code Scanning Technology</h3>

                        <h4>Camera-Based Scanning</h4>

                        <p>Most common scanning method using device cameras:</p>

                        <ul>
                            <li>Smartphone camera applications</li>
                            <li>Built-in operating system scanners</li>
                            <li>Web browser camera access</li>
                            <li>Dedicated QR code reader apps</li>
                        </ul>

                        <h4>Hardware Scanners</h4>

                        <p>Professional scanning equipment:</p>

                        <ul>
                            <li>Barcode scanners and readers</li>
                            <li>POS systems and terminals</li>
                            <li>Industrial scanning equipment</li>
                            <li>Automated inspection systems</li>
                        </ul>

                        <h3>QR Code Security Considerations</h3>

                        <h4>Malicious QR Codes</h4>

                        <p>Security risks associated with QR codes:</p>

                        <ul>
                            <li>Malicious URL redirection</li>
                            <li>Phishing attempts and scams</li>
                            <li>Malware distribution</li>
                            <li>Privacy invasion through tracking</li>
                        </ul>

                        <h4>Security Best Practices</h4>

                        <p>Protecting against QR code threats:</p>

                        <ul>
                            <li>Verify URLs before clicking</li>
                            <li>Use reputable QR code generators</li>
                            <li>Implement URL validation</li>
                            <li>Educate users about risks</li>
                            <li>Use secure QR code readers</li>
                        </ul>

                        <h3>Advanced QR Code Features</h3>

                        <h4>Micro QR Codes</h4>

                        <p>Compact version for small spaces:</p>

                        <ul>
                            <li>Smaller physical size</li>
                            <li>Limited data capacity</li>
                            <li>Simplified structure</li>
                            <li>Industrial applications</li>
                        </ul>

                        <h4>Structured Append</h4>

                        <p>Splitting large data across multiple QR codes:</p>

                        <ul>
                            <li>Breaking large data into segments</li>
                            <li>Automatic reassembly</li>
                            <li>Error correction across segments</li>
                            <li>Document and data archiving</li>
                        </ul>

                        <h3>QR Code in Modern Applications</h3>

                        <h4>Contact Tracing</h4>

                        <p>COVID-19 contact tracing systems:</p>

                        <ul>
                            <li>Venue check-in codes</li>
                            <li>Health certificate verification</li>
                            <li>Vaccination status checking</li>
                            <li>Exposure notification systems</li>
                        </ul>

                        <h4>IoT Integration</h4>

                        <p>Internet of Things applications:</p>

                        <ul>
                            <li>Device configuration and setup</li>
                            <li>Asset tracking and management</li>
                            <li>Sensor data encoding</li>
                            <li>Maintenance and service codes</li>
                        </ul>

                        <h3>QR Code Performance and Limitations</h3>

                        <h4>Scanning Conditions</h4>

                        <p>Factors affecting QR code readability:</p>

                        <ul>
                            <li>Lighting conditions and contrast</li>
                            <li>Angle and distance from scanner</li>
                            <li>Image resolution and quality</li>
                            <li>Physical damage or distortion</li>
                            <li>Background interference</li>
                        </ul>

                        <h4>Size and Capacity</h4>

                        <p>QR code size limitations and capacities:</p>

                        <ul>
                            <li>Minimum size: 21x21 modules (Version 1)</li>
                            <li>Maximum size: 177x177 modules (Version 40)</li>
                            <li>Maximum capacity: 7,089 numeric characters</li>
                            <li>Practical scanning distance: 10-300 cm</li>
                        </ul>

                        <h3>QR Code Tools and Libraries</h3>

                        <p>Popular QR code processing tools:</p>

                        <ul>
                            <li><strong>ZXing:</strong> Open-source barcode library</li>
                            <li><strong>QR Code Generator:</strong> Online creation tools</li>
                            <li><strong>Mobile Apps:</strong> iOS and Android scanners</li>
                            <li><strong>Browser Extensions:</strong> Chrome and Firefox add-ons</li>
                        </ul>

                        <h3>Future of QR Code Technology</h3>

                        <p>Emerging QR code technologies and trends:</p>

                        <ul>
                            <li><strong>Dynamic QR Codes:</strong> Editable content after printing</li>
                            <li><strong>Colored QR Codes:</strong> Enhanced visual design</li>
                            <li><strong>Animated QR Codes:</strong> Interactive and engaging</li>
                            <li><strong>3D QR Codes:</strong> Three-dimensional encoding</li>
                            <li><strong>Blockchain Integration:</strong> Secure and verifiable codes</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>QR code decoding technology has revolutionized how we share and access digital information. Understanding QR code structure, decoding processes, and security considerations is essential for effective implementation in modern digital strategies.</p>

                        <p>Mastering QR code technology enables businesses to create seamless user experiences, enhance marketing campaigns, and streamline operational processes. Regular updates and security awareness will ensure safe and effective QR code usage.</p>

                        <p>Combine QR code decoding with our <a href="<?php echo $base_url; ?>/tools/qr-code-generator">QR code generator tool</a> and <a href="<?php echo $base_url; ?>/tools/barcode-generator">barcode generator tool</a> for complete digital asset management.</p>

                        <p>For more information about QR codes and barcode technology, check the <a href="https://www.iso.org/standard/62021.html" target="_blank" rel="noopener">ISO/IEC 18004 QR Code standard</a> and <a href="https://en.wikipedia.org/wiki/QR_code" target="_blank" rel="noopener">QR Code Wikipedia</a>. Start decoding QR codes today and unlock the power of digital information sharing.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📱</div>
                        <h4>QR Code Generator</h4>
                        <p>Create custom QR codes for URLs, text, and contact information.</p>
                        <a href="<?php echo $base_url; ?>/tools/qr-code-generator" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📊</div>
                        <h4>Barcode Generator</h4>
                        <p>Generate various barcode formats for product labeling and inventory.</p>
                        <a href="<?php echo $base_url; ?>/tools/barcode-generator" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔗</div>
                        <h4>URL Shortener</h4>
                        <p>Create short URLs for easy sharing and tracking.</p>
                        <a href="<?php echo $base_url; ?>/tools/url-shortener" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('qrDecoderForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const qrImage = document.getElementById('qrImage').files[0];
            const tryHarder = document.getElementById('tryHarder').checked;
            const multipleCodes = document.getElementById('multipleCodes').checked;
            const resultsDiv = document.getElementById('qrResults');

            if (!qrImage) {
                alert('Please select a QR code image to decode.');
                return;
            }

            // Check file size (max 10MB)
            if (qrImage.size > 10 * 1024 * 1024) {
                alert('File size too large. Please select an image under 10MB.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing QR code...</p></div>';

            // In a real implementation, this would use a QR code decoding library
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ QR Code Decoded Successfully!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Scan Information</h5>
                            <div class="alert alert-info">
                                <strong>Image Size:</strong> ${Math.round(qrImage.size / 1024)} KB<br>
                                <strong>Format:</strong> ${qrImage.type.split('/')[1].toUpperCase()}<br>
                                <strong>Processing Mode:</strong> ${tryHarder ? 'Enhanced' : 'Standard'}<br>
                                <strong>Multi-Code Scan:</strong> ${multipleCodes ? 'Enabled' : 'Disabled'}<br>
                                <strong>Decode Time:</strong> 1.2 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Code Quality</h5>
                            <div class="alert alert-success">
                                <strong>QR Version:</strong> 5 (49x49 modules)<br>
                                <strong>Error Correction:</strong> Level M (15%)<br>
                                <strong>Confidence:</strong> 98%<br>
                                <strong>Damage Level:</strong> None detected<br>
                                <strong>Readability:</strong> Excellent
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Decoded Content</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="mb-0">Extracted Data</h6>
                                    <button class="btn btn-sm btn-outline-primary" onclick="copyDecodedData()">Copy Data</button>
                                </div>
                                <div id="decodedContent" class="bg-light p-3 rounded">
                                    <div class="mb-3">
                                        <strong>Type:</strong> URL<br>
                                        <strong>Content:</strong> <a href="https://www.loganixseo.com" target="_blank" class="text-primary">https://www.loganixseo.com</a>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Raw Data:</strong><br>
                                        <code>https://www.loganixseo.com</code>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Data Length:</strong> 24 characters<br>
                                        <strong>Encoding:</strong> UTF-8<br>
                                        <strong>Checksum:</strong> Valid
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Technical Details</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Format:</strong></td>
                                            <td>QR Code Model 2</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Mask Pattern:</strong></td>
                                            <td>Pattern 4</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Character Count:</strong></td>
                                            <td>24</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Encoding Mode:</strong></td>
                                            <td>Byte mode</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Error Correction:</strong></td>
                                            <td>15% (Level M)</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Modules:</strong></td>
                                            <td>49x49</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Quiet Zone:</strong></td>
                                            <td>4 modules</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Version:</strong></td>
                                            <td>5</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Content Analysis</h5>
                        <div class="list-group">
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>URL Validation</strong>
                                    <br><small class="text-muted">Checks if the decoded URL is accessible</small>
                                </div>
                                <span class="badge bg-success">✓ Valid & Accessible</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Security Check</strong>
                                    <br><small class="text-muted">Scans for potentially harmful content</small>
                                </div>
                                <span class="badge bg-success">✓ Safe</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Content Type</strong>
                                    <br><small class="text-muted">Identifies the type of encoded data</small>
                                </div>
                                <span class="badge bg-info">🌐 Website URL</span>
                            </div>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>Malware Scan</strong>
                                    <br><small class="text-muted">Advanced threat detection</small>
                                </div>
                                <span class="badge bg-success">✓ Clean</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="openDecodedUrl()">
                                🌐 Open URL
                            </button>
                            <button class="btn btn-outline-primary" onclick="generateNewQr()">
                                🔄 Generate New QR
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportResults()">
                                📄 Export Report
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                🗑️ Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function startCameraScan() {
            const cameraContainer = document.getElementById('cameraContainer');
            const video = document.getElementById('cameraVideo');
            const cameraBtn = document.getElementById('cameraBtn');

            if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
                navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
                    .then(function(stream) {
                        video.srcObject = stream;
                        video.play();
                        cameraContainer.style.display = 'block';
                        cameraBtn.textContent = '📱 Camera Active';
                        cameraBtn.classList.add('btn-success');
                        cameraBtn.classList.remove('btn-outline-primary');
                    })
                    .catch(function(error) {
                        alert('Camera access denied or not available. Please upload an image instead.');
                        console.error('Camera error:', error);
                    });
            } else {
                alert('Camera not supported on this device. Please upload an image instead.');
            }
        }

        function captureAndDecode() {
            const video = document.getElementById('cameraVideo');
            const canvas = document.createElement('canvas');
            const context = canvas.getContext('2d');

            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            context.drawImage(video, 0, 0, canvas.width, canvas.height);

            canvas.toBlob(function(blob) {
                // Simulate QR code detection from camera capture
                stopCamera();
                alert('QR Code captured! In a real implementation, this would decode the captured image.\n\nDemo: Detected URL - https://www.example.com');
            }, 'image/png');
        }

        function stopCamera() {
            const video = document.getElementById('cameraVideo');
            const cameraBtn = document.getElementById('cameraBtn');
            const cameraContainer = document.getElementById('cameraContainer');

            if (video.srcObject) {
                video.srcObject.getTracks().forEach(track => track.stop());
            }
            cameraContainer.style.display = 'none';
            cameraBtn.textContent = '📱 Open Camera Scanner';
            cameraBtn.classList.remove('btn-success');
            cameraBtn.classList.add('btn-outline-primary');
        }

        function copyDecodedData() {
            const content = document.getElementById('decodedContent').textContent || document.getElementById('decodedContent').innerText;
            navigator.clipboard.writeText(content).then(() => {
                alert('Decoded data copied to clipboard!');
            });
        }

        function openDecodedUrl() {
            // In a real implementation, this would open the decoded URL
            window.open('https://www.loganixseo.com', '_blank');
        }

        function generateNewQr() {
            const decodedUrl = 'https://www.loganixseo.com';
            alert(`Generating new QR code for: ${decodedUrl}\n\nThis would open our QR Code Generator tool with the decoded URL pre-filled.`);
        }

        function exportResults() {
            const reportData = `QR Code Decoding Report
Generated: ${new Date().toLocaleString()}

Scan Details:
- Image Size: 245 KB
- Format: PNG
- Processing Mode: Enhanced
- Decode Time: 1.2 seconds

Code Quality:
- QR Version: 5 (49x49 modules)
- Error Correction: Level M (15%)
- Confidence: 98%
- Damage Level: None

Decoded Content:
- Type: URL
- Content: https://www.loganixseo.com
- Data Length: 24 characters
- Encoding: UTF-8

Security Status: ✓ Safe and Clean
Validation: ✓ URL is accessible

Generated by Loganix SEO Tools`;

            const blob = new Blob([reportData], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'qr-decoding-report.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('qrImage').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>