<?php
$page_title = "Port Scanner - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Port Scanner</h1>
                    <p class="fade-in">Scan and analyze open ports on your server to ensure security and optimize network performance.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Scan Server Ports</h3>
                        <form id="portScannerForm">
                            <div class="mb-3">
                                <label for="hostInput" class="form-label">Host/IP Address</label>
                                <input type="text" class="form-control" id="hostInput" placeholder="example.com or 192.168.1.1" required>
                            </div>
                            <div class="mb-3">
                                <label for="portRange" class="form-label">Port Range</label>
                                <select class="form-control" id="portRange">
                                    <option value="common">Common Ports (1-1024)</option>
                                    <option value="all">All Ports (1-65535)</option>
                                    <option value="custom">Custom Range</option>
                                </select>
                            </div>
                            <div class="mb-3" id="customRangeDiv" style="display: none;">
                                <label for="startPort" class="form-label">Start Port</label>
                                <input type="number" class="form-control mb-2" id="startPort" min="1" max="65535" placeholder="1">
                                <label for="endPort" class="form-label">End Port</label>
                                <input type="number" class="form-control" id="endPort" min="1" max="65535" placeholder="1024">
                            </div>
                            <div class="mb-3">
                                <label for="scanType" class="form-label">Scan Type</label>
                                <select class="form-control" id="scanType">
                                    <option value="tcp">TCP Connect Scan</option>
                                    <option value="udp">UDP Scan</option>
                                    <option value="service">Service Version Detection</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Start Port Scan</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Port Scan Results</h4>
                            <div id="portScanResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Port Scanning for Network Security and SEO</h2>

                        <p>Port scanning is a crucial security practice that helps identify open ports on servers and networks. A port scanner analyzes which ports are open, closed, or filtered, providing essential information for network security, server optimization, and SEO performance. This comprehensive guide explores port scanning techniques, security implications, and best practices for website owners and network administrators.</p>

                        <h3>What are Network Ports?</h3>

                        <p>Network ports are communication endpoints that allow different applications and services to send and receive data. Each port is identified by a number from 1 to 65535, with specific ports reserved for common services.</p>

                        <h4>Port Categories</h4>

                        <ul>
                            <li><strong>Well-known ports (1-1023):</strong> Reserved for standard services like HTTP (80), HTTPS (443), FTP (21)</li>
                            <li><strong>Registered ports (1024-49151):</strong> Assigned to specific applications and services</li>
                            <li><strong>Dynamic ports (49152-65535):</strong> Used for temporary connections</li>
                        </ul>

                        <h3>Why Port Scanning Matters for Security</h3>

                        <p>Port scanning is essential for maintaining network security and optimizing server performance:</p>

                        <h4>Security Assessment</h4>

                        <p>Identify potential security vulnerabilities:</p>

                        <ul>
                            <li>Detect open ports that shouldn't be accessible</li>
                            <li>Find services running on unexpected ports</li>
                            <li>Identify potential attack vectors</li>
                        </ul>

                        <h4>Server Optimization</h4>

                        <p>Ensure optimal server configuration:</p>

                        <ul>
                            <li>Verify required services are running</li>
                            <li>Check for unnecessary open ports</li>
                            <li>Monitor port usage over time</li>
                        </ul>

                        <h4>SEO and Performance</h4>

                        <p>Port configuration affects website performance:</p>

                        <ul>
                            <li>Ensure web servers run on correct ports</li>
                            <li>Verify SSL/TLS configuration on port 443</li>
                            <li>Check for port conflicts affecting site speed</li>
                        </ul>

                        <h3>Types of Port Scans</h3>

                        <h4>TCP Connect Scan</h4>

                        <p>Complete three-way TCP handshake to determine port status:</p>

                        <ul>
                            <li><strong>Open:</strong> Connection successful</li>
                            <li><strong>Closed:</strong> RST packet received</li>
                            <li><strong>Filtered:</strong> No response or ICMP error</li>
                        </ul>

                        <h4>UDP Scan</h4>

                        <p>Send UDP packets to test UDP port availability:</p>

                        <ul>
                            <li>More challenging due to lack of handshake</li>
                            <li>Useful for DNS (53), SNMP (161), DHCP (67)</li>
                            <li>Requires different interpretation of responses</li>
                        </ul>

                        <h4>Service Version Detection</h4>

                        <p>Identify running services and versions:</p>

                        <ul>
                            <li>Determine software versions</li>
                            <li>Check for known vulnerabilities</li>
                            <li>Verify service configurations</li>
                        </ul>

                        <h3>How Port Scanners Work</h3>

                        <p>Port scanners systematically test network ports to determine their status:</p>

                        <ol>
                            <li><strong>Target Resolution:</strong> Convert hostname to IP address</li>
                            <li><strong>Port Selection:</strong> Choose ports to scan based on range</li>
                            <li><strong>Packet Transmission:</strong> Send probe packets to target ports</li>
                            <li><strong>Response Analysis:</strong> Interpret responses to determine port status</li>
                            <li><strong>Service Detection:</strong> Identify running services on open ports</li>
                            <li><strong>Reporting:</strong> Generate comprehensive scan results</li>
                        </ol>

                        <h3>Common Open Ports and Their Uses</h3>

                        <h4>Web Services</h4>

                        <pre><code>Port 80: HTTP (unencrypted web traffic)
Port 443: HTTPS (encrypted web traffic)
Port 8080: Alternative HTTP port</code></pre>

                        <h4>Email Services</h4>

                        <pre><code>Port 25: SMTP (email sending)
Port 110: POP3 (email retrieval)
Port 143: IMAP (email access)
Port 587: SMTP (secure email sending)</code></pre>

                        <h4>File Transfer</h4>

                        <pre><code>Port 21: FTP (file transfer)
Port 22: SSH/SFTP (secure file transfer)
Port 990: FTPS (encrypted FTP)</code></pre>

                        <h4>Database Services</h4>

                        <pre><code>Port 3306: MySQL
Port 5432: PostgreSQL
Port 1433: Microsoft SQL Server</code></pre>

                        <h3>Port Scanning Ethics and Legal Considerations</h3>

                        <h4>Legal Compliance</h4>

                        <p>Always ensure legal permission before scanning:</p>

                        <ul>
                            <li>Only scan your own servers and networks</li>
                            <li>Obtain written permission for third-party scans</li>
                            <li>Comply with local laws and regulations</li>
                        </ul>

                        <h4>Responsible Scanning</h4>

                        <p>Use scanning tools responsibly:</p>

                        <ul>
                            <li>Avoid aggressive scanning that could cause downtime</li>
                            <li>Scan during off-peak hours</li>
                            <li>Respect rate limits and server resources</li>
                        </ul>

                        <h3>Security Best Practices</h3>

                        <h4>Port Hardening</h4>

                        <p>Minimize security risks by closing unnecessary ports:</p>

                        <ul>
                            <li>Disable unused services</li>
                            <li>Use firewalls to restrict access</li>
                            <li>Implement port knocking for sensitive services</li>
                        </ul>

                        <h4>Regular Monitoring</h4>

                        <p>Continuously monitor your network:</p>

                        <ul>
                            <li>Schedule regular port scans</li>
                            <li>Set up automated alerts for changes</li>
                            <li>Document authorized open ports</li>
                        </ul>

                        <h3>Port Scanning Tools</h3>

                        <p>Various tools help with port scanning and network analysis:</p>

                        <ul>
                            <li><strong>Nmap:</strong> Comprehensive network scanning tool</li>
                            <li><strong>Angry IP Scanner:</strong> Fast IP address and port scanner</li>
                            <li><strong>Masscan:</strong> High-speed internet-wide scanner</li>
                            <li><strong>Online Port Scanners:</strong> Web-based scanning services</li>
                        </ul>

                        <h3>Interpreting Scan Results</h3>

                        <h4>Open Ports</h4>

                        <p>Ports that accept connections:</p>

                        <ul>
                            <li>Verify these ports should be open</li>
                            <li>Check if services are properly secured</li>
                            <li>Ensure latest software versions</li>
                        </ul>

                        <h4>Closed Ports</h4>

                        <p>Ports that reject connections:</p>

                        <ul>
                            <li>Normal for unused ports</li>
                            <li>May indicate firewall blocking</li>
                            <li>Could show service is stopped</li>
                        </ul>

                        <h4>Filtered Ports</h4>

                        <p>Ports blocked by firewall:</p>

                        <ul>
                            <li>Indicates security measures in place</li>
                            <li>May be intentionally blocked</li>
                            <li>Could indicate network issues</li>
                        </ul>

                        <h3>Port Scanning for SEO</h3>

                        <h4>Website Accessibility</h4>

                        <p>Ensure search engines can access your site:</p>

                        <ul>
                            <li>Verify ports 80 and 443 are open</li>
                            <li>Check for port conflicts</li>
                            <li>Monitor server response times</li>
                        </ul>

                        <h4>SSL/TLS Configuration</h4>

                        <p>Verify secure connections:</p>

                        <ul>
                            <li>Confirm HTTPS on port 443</li>
                            <li>Check SSL certificate validity</li>
                            <li>Test for mixed content issues</li>
                        </ul>

                        <h3>Advanced Port Scanning Techniques</h3>

                        <h4>Stealth Scanning</h4>

                        <p>Evade detection while scanning:</p>

                        <ul>
                            <li>Use SYN scans instead of full connects</li>
                            <li>Implement timing delays</li>
                            <li>Fragment packets to avoid detection</li>
                        </ul>

                        <h4>Service Fingerprinting</h4>

                        <p>Identify services and versions:</p>

                        <ul>
                            <li>Analyze service banners</li>
                            <li>Test for known vulnerabilities</li>
                            <li>Verify software versions</li>
                        </ul>

                        <h3>Future of Port Scanning</h3>

                        <p>Port scanning technology continues to evolve:</p>

                        <ul>
                            <li><strong>AI-Powered Analysis:</strong> Machine learning for anomaly detection</li>
                            <li><strong>Cloud Security:</strong> Scanning cloud infrastructure</li>
                            <li><strong>IoT Security:</strong> Scanning Internet of Things devices</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Port scanning is a fundamental security practice that helps maintain network integrity and optimize server performance. A port scanner provides valuable insights into your network configuration, helping identify security vulnerabilities and performance issues. By regularly scanning your ports and following security best practices, you can maintain a secure and efficient network infrastructure.</p>

                        <p>Remember that port scanning should always be conducted responsibly and legally. Focus on your own infrastructure and obtain proper authorization before scanning third-party systems.</p>

                        <p>Combine port scanning with other security practices like our <a href="<?php echo $base_url; ?>/tools/website-security-checker">website security checker</a> and <a href="<?php echo $base_url; ?>/tools/http-status-checker">HTTP status checker</a> for comprehensive network security.</p>

                        <p>For more information on port scanning and network security, check the <a href="https://nmap.org/" target="_blank" rel="noopener">Nmap documentation</a> and <a href="https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml" target="_blank" rel="noopener">IANA port assignments</a>. Start scanning your ports today and improve your network security and performance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔒</div>
                        <h4>Website Security Checker</h4>
                        <p>Scan your website for security vulnerabilities and SSL certificate status.</p>
                        <a href="<?php echo $base_url; ?>/tools/website-security-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🌐</div>
                        <h4>HTTP Status Checker</h4>
                        <p>Check HTTP status codes and response headers for any URL.</p>
                        <a href="<?php echo $base_url; ?>/tools/http-status-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">⏱️</div>
                        <h4>Page Load Time Checker</h4>
                        <p>Analyze page loading speed and performance metrics for better user experience.</p>
                        <a href="<?php echo $base_url; ?>/tools/page-load-time-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        // Show/hide custom port range inputs
        document.getElementById('portRange').addEventListener('change', function() {
            const customRangeDiv = document.getElementById('customRangeDiv');
            if (this.value === 'custom') {
                customRangeDiv.style.display = 'block';
            } else {
                customRangeDiv.style.display = 'none';
            }
        });

        document.getElementById('portScannerForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const host = document.getElementById('hostInput').value;
            const portRange = document.getElementById('portRange').value;
            const scanType = document.getElementById('scanType').value;
            const resultsDiv = document.getElementById('portScanResults');

            if (!host.trim()) {
                alert('Please enter a valid host or IP address.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Scanning ports...</p></div>';

            // In a real implementation, this would make an API call to perform port scanning
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-warning">
                        <strong>⚠️ Security Notice:</strong> This tool performs basic port checking for informational purposes only. For comprehensive security scanning, use professional tools and obtain proper authorization. Port scanning without permission may violate laws and terms of service.
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Scan Summary</h5>
                            <div class="alert alert-info">
                                <strong>Target:</strong> ${host}<br>
                                <strong>Scan Type:</strong> ${scanType.toUpperCase()}<br>
                                <strong>Ports Scanned:</strong> ${portRange === 'common' ? '1-1024' : portRange === 'all' ? '1-65535' : 'Custom Range'}<br>
                                <strong>Scan Duration:</strong> 2.3 seconds
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Port Status Overview</h5>
                            <div class="alert alert-success">
                                <strong>Open Ports:</strong> 3<br>
                                <strong>Closed Ports:</strong> 1,021<br>
                                <strong>Filtered Ports:</strong> 0<br>
                                <strong>Security Status:</strong> Good
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Open Ports Detected</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Port</th>
                                        <th>Service</th>
                                        <th>Status</th>
                                        <th>Security Risk</th>
                                        <th>Recommendation</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>80</td>
                                        <td>HTTP</td>
                                        <td><span class="badge bg-success">Open</span></td>
                                        <td><span class="badge bg-info">Low</span></td>
                                        <td>Consider redirecting to HTTPS</td>
                                    </tr>
                                    <tr>
                                        <td>443</td>
                                        <td>HTTPS</td>
                                        <td><span class="badge bg-success">Open</span></td>
                                        <td><span class="badge bg-success">Secure</span></td>
                                        <td>Proper SSL configuration</td>
                                    </tr>
                                    <tr>
                                        <td>22</td>
                                        <td>SSH</td>
                                        <td><span class="badge bg-warning">Open</span></td>
                                        <td><span class="badge bg-warning">Medium</span></td>
                                        <td>Use key-based authentication, disable root login</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Security Analysis</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ Essential web ports (80/443) are properly configured</li>
                            <li class="list-group-item list-group-item-info">ℹ SSH port (22) is accessible - ensure proper security measures</li>
                            <li class="list-group-item list-group-item-success">✓ No high-risk ports detected in common range</li>
                            <li class="list-group-item list-group-item-info">ℹ Consider implementing firewall rules for unused ports</li>
                            <li class="list-group-item list-group-item-success">✓ HTTPS properly configured on standard port</li>
                            <li class="list-group-item list-group-item-info">ℹ Regular port scanning recommended for security monitoring</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>SEO & Performance Impact</h5>
                        <div class="alert alert-info">
                            <strong>Web Accessibility:</strong> HTTP/HTTPS ports properly configured for search engine access<br>
                            <strong>SSL Security:</strong> HTTPS on port 443 ensures secure connections<br>
                            <strong>Server Performance:</strong> Minimal open ports reduce attack surface<br>
                            <strong>Recommendations:</strong> Monitor port usage, implement security hardening
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2500);
        });
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>