<?php
$page_title = "Page Size Checker - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Page Size Checker</h1>
                    <p class="fade-in">Check your page size and loading performance to optimize user experience and Core Web Vitals.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Analyze Page Size</h3>
                        <form id="pageSizeForm">
                            <div class="mb-3">
                                <label for="urlInput" class="form-label">Website URL</label>
                                <input type="url" class="form-control" id="urlInput" placeholder="https://example.com" required>
                            </div>
                            <div class="mb-3">
                                <label for="analysisType" class="form-label">Analysis Type</label>
                                <select class="form-control" id="analysisType">
                                    <option value="basic">Basic Size Analysis</option>
                                    <option value="detailed">Detailed Resource Breakdown</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Check Page Size</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Page Size Analysis Results</h4>
                            <div id="pageSizeResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to Page Size Optimization for SEO and Performance</h2>

                        <p>Page size checking is crucial for website performance and user experience. A page size checker analyzes total page weight, resource breakdown, and optimization opportunities to improve loading speeds and Core Web Vitals. This comprehensive guide explores page size optimization, performance metrics, and best practices for faster websites.</p>

                        <h3>What is Page Size?</h3>

                        <p>Page size refers to the total amount of data that needs to be downloaded to display a web page, including HTML, CSS, JavaScript, images, fonts, and other resources.</p>

                        <h4>Size Components</h4>

                        <ul>
                            <li><strong>HTML:</strong> Page structure and content</li>
                            <li><strong>CSS:</strong> Stylesheets and styling</li>
                            <li><strong>JavaScript:</strong> Interactive functionality</li>
                            <li><strong>Images:</strong> Visual content and media</li>
                            <li><strong>Fonts:</strong> Typography and text styling</li>
                            <li><strong>Other:</strong> Videos, documents, third-party resources</li>
                        </ul>

                        <h3>Why Page Size Matters for SEO</h3>

                        <p>Page size directly impacts search engine optimization:</p>

                        <h4>Loading Speed</h4>

                        <p>Larger pages take longer to load:</p>

                        <ul>
                            <li>Slow loading increases bounce rates</li>
                            <li>Page speed is a ranking factor</li>
                            <li>Mobile users are particularly affected</li>
                        </ul>

                        <h4>Core Web Vitals</h4>

                        <p>Page size affects CWV metrics:</p>

                        <ul>
                            <li>Largest Contentful Paint (LCP)</li>
                            <li>First Input Delay (FID)</li>
                            <li>Cumulative Layout Shift (CLS)</li>
                        </ul>

                        <h4>User Experience</h4>

                        <p>Page size impacts user satisfaction:</p>

                        <ul>
                            <li>Data usage on mobile devices</li>
                            <li>Accessibility for slow connections</li>
                            <li>Overall site usability</li>
                        </ul>

                        <h3>How Page Size Checkers Work</h3>

                        <p>Size analysis tools examine all page resources:</p>

                        <ol>
                            <li><strong>Page Loading:</strong> Access target URL and load all resources</li>
                            <li><strong>Resource Inventory:</strong> Catalog all files and assets</li>
                            <li><strong>Size Measurement:</strong> Calculate total and individual file sizes</li>
                            <li><strong>Performance Analysis:</strong> Assess loading impact and bottlenecks</li>
                            <li><strong>Optimization Recommendations:</strong> Suggest improvements and fixes</li>
                            <li><strong>Comparative Analysis:</strong> Benchmark against industry standards</li>
                        </ol>

                        <h3>Optimal Page Size Guidelines</h3>

                        <h4>Desktop Recommendations</h4>

                        <ul>
                            <li><strong>Ideal:</strong> Under 1.5 MB</li>
                            <li><strong>Acceptable:</strong> 1.5 - 3 MB</li>
                            <li><strong>Slow:</strong> Over 3 MB</li>
                        </ul>

                        <h4>Mobile Recommendations</h4>

                        <ul>
                            <li><strong>Ideal:</strong> Under 1 MB</li>
                            <li><strong>Acceptable:</strong> 1 - 2 MB</li>
                            <li><strong>Slow:</strong> Over 2 MB</li>
                        </ul>

                        <h3>Common Page Size Issues</h3>

                        <h4>Unoptimized Images</h4>

                        <p>Large image files dominate page size:</p>

                        <ul>
                            <li>Uncompressed images</li>
                            <li>Incorrect file formats</li>
                            <li>Missing responsive images</li>
                        </ul>

                        <h4>Bloated JavaScript</h4>

                        <p>JavaScript files can be excessively large:</p>

                        <ul>
                            <li>Unminified code</li>
                            <li>Unused JavaScript</li>
                            <li>Large third-party libraries</li>
                        </ul>

                        <h4>Excessive Resources</h4>

                        <p>Too many files slow loading:</p>

                        <ul>
                            <li>Multiple CSS files</li>
                            <li>Redundant scripts</li>
                            <li>Unnecessary fonts</li>
                        </ul>

                        <h3>Page Size Optimization Strategies</h3>

                        <h4>Image Optimization</h4>

                        <p>Reduce image file sizes:</p>

                        <ul>
                            <li>Compress images (70-80% quality)</li>
                            <li>Use modern formats (WebP, AVIF)</li>
                            <li>Implement lazy loading</li>
                            <li>Create responsive images</li>
                        </ul>

                        <h4>Code Minification</h4>

                        <p>Reduce code file sizes:</p>

                        <ul>
                            <li>Minify HTML, CSS, and JavaScript</li>
                            <li>Remove unused code</li>
                            <li>Use GZIP compression</li>
                            <li>Enable Brotli compression</li>
                        </ul>

                        <h4>Resource Optimization</h4>

                        <p>Optimize resource delivery:</p>

                        <ul>
                            <li>Use Content Delivery Networks (CDN)</li>
                            <li>Implement caching headers</li>
                            <li>Combine files to reduce requests</li>
                            <li>Defer non-critical resources</li>
                        </ul>

                        <h3>Measuring Page Size Impact</h3>

                        <p>Track the effects of size optimization:</p>

                        <ul>
                            <li><strong>Loading Speed:</strong> Measure page load times</li>
                            <li><strong>Core Web Vitals:</strong> Monitor LCP and other metrics</li>
                            <li><strong>User Experience:</strong> Track bounce rates and engagement</li>
                            <li><strong>Conversion Rates:</strong> Monitor goal completions</li>
                        </ul>

                        <h3>Page Size Analysis Tools</h3>

                        <p>Various tools help analyze page size:</p>

                        <ul>
                            <li><strong>Google PageSpeed Insights:</strong> Comprehensive performance analysis</li>
                            <li><strong>GTmetrix:</strong> Detailed size and loading breakdown</li>
                            <li><strong>WebPageTest:</strong> Advanced performance testing</li>
                            <li><strong>Lighthouse:</strong> Google performance auditing</li>
                        </ul>

                        <h3>Mobile Page Size Considerations</h3>

                        <h4>Mobile Optimization</h4>

                        <p>Mobile devices have specific constraints:</p>

                        <ul>
                            <li>Limited bandwidth and data caps</li>
                            <li>Slower connection speeds</li>
                            <li>Smaller screen sizes</li>
                        </ul>

                        <h4>Mobile-First Approach</h4>

                        <p>Design for mobile first:</p>

                        <ul>
                            <li>Prioritize critical content</li>
                            <li>Optimize for mobile networks</li>
                            <li>Test on real mobile devices</li>
                        </ul>

                        <h3>Advanced Size Optimization</h3>

                        <h4>Critical Resource Loading</h4>

                        <p>Prioritize above-the-fold content:</p>

                        <ul>
                            <li>Inline critical CSS</li>
                            <li>Preload important resources</li>
                            <li>Use resource hints</li>
                        </ul>

                        <h4>Progressive Loading</h4>

                        <p>Load content progressively:</p>

                        <ul>
                            <li>Lazy load images and videos</li>
                            <li>Use infinite scroll carefully</li>
                            <li>Implement virtual scrolling</li>
                        </ul>

                        <h3>Page Size and SEO Best Practices</h3>

                        <h4>Performance Budget</h4>

                        <p>Set size limits for pages:</p>

                        <ul>
                            <li>Define acceptable page sizes</li>
                            <li>Monitor bundle sizes</li>
                            <li>Set up automated alerts</li>
                        </ul>

                        <h4>Regular Monitoring</h4>

                        <p>Continuously monitor page size:</p>

                        <ul>
                            <li>Regular performance audits</li>
                            <li>Monitor third-party resources</li>
                            <li>Track size trends over time</li>
                        </ul>

                        <h3>Future of Page Size Optimization</h3>

                        <p>Page size technology continues to evolve:</p>

                        <ul>
                            <li><strong>HTTP/3:</strong> More efficient data transfer</li>
                            <li><strong>Edge Computing:</strong> Content delivery optimization</li>
                            <li><strong>AI Optimization:</strong> Smart resource loading</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>Page size checking is essential for website performance and SEO optimization. A page size checker analyzes total page weight and provides optimization recommendations to improve loading speeds and user experience. By implementing proper size optimization techniques, you can improve Core Web Vitals, reduce bounce rates, and enhance search engine rankings.</p>

                        <p>Remember that page size optimization is an ongoing process. Regular monitoring and optimization are key to maintaining optimal performance.</p>

                        <p>Combine page size analysis with other performance tools like our <a href="<?php echo $base_url; ?>/tools/page-load-time-checker">page load time checker</a> and <a href="<?php echo $base_url; ?>/tools/google-cache-checker">Google cache checker</a> for comprehensive website optimization.</p>

                        <p>For more information on page size optimization, check the <a href="https://developers.google.com/speed/docs/insights/mobile" target="_blank" rel="noopener">Google mobile optimization guide</a> and <a href="https://web.dev/vitals/" target="_blank" rel="noopener">Core Web Vitals documentation</a>. Start checking your page sizes today and improve your website performance.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">⏱️</div>
                        <h4>Page Load Time Checker</h4>
                        <p>Analyze page loading speed and performance metrics for better user experience.</p>
                        <a href="<?php echo $base_url; ?>/tools/page-load-time-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🖼️</div>
                        <h4>Image Alt Checker</h4>
                        <p>Analyze image alt text attributes for SEO and accessibility.</p>
                        <a href="<?php echo $base_url; ?>/tools/image-alt-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>Google Cache Checker</h4>
                        <p>Check how Google caches and indexes your web pages for SEO analysis.</p>
                        <a href="<?php echo $base_url; ?>/tools/google-cache-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('pageSizeForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const url = document.getElementById('urlInput').value;
            const analysisType = document.getElementById('analysisType').value;
            const resultsDiv = document.getElementById('pageSizeResults');

            if (!url) {
                alert('Please enter a URL to analyze.');
                return;
            }

            // Basic URL validation
            try {
                new URL(url);
            } catch {
                alert('Please enter a valid URL.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Analyzing page size...</p></div>';

            // In a real implementation, this would analyze the actual page
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ Page Size Analysis Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Overall Page Size</h5>
                            <div class="alert alert-info">
                                <strong>Total Size:</strong> 2.1 MB<br>
                                <strong>Requests:</strong> 47<br>
                                <strong>Loading Time:</strong> 3.2 seconds<br>
                                <strong>Performance Grade:</strong> <span class="badge bg-warning">Needs Improvement</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Size Breakdown</h5>
                            <div class="alert alert-warning">
                                <strong>Images:</strong> 1.4 MB (67%)<br>
                                <strong>JavaScript:</strong> 380 KB (18%)<br>
                                <strong>CSS:</strong> 156 KB (7%)<br>
                                <strong>HTML:</strong> 45 KB (2%)<br>
                                <strong>Fonts:</strong> 89 KB (4%)<br>
                                <strong>Other:</strong> 40 KB (2%)
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Detailed Resource Analysis</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Resource Type</th>
                                        <th>Size</th>
                                        <th>Requests</th>
                                        <th>Average Size</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Images</td>
                                        <td>1.4 MB</td>
                                        <td>12</td>
                                        <td>119 KB</td>
                                        <td><span class="badge bg-danger">Too Large</span></td>
                                    </tr>
                                    <tr>
                                        <td>JavaScript</td>
                                        <td>380 KB</td>
                                        <td>8</td>
                                        <td>48 KB</td>
                                        <td><span class="badge bg-warning">Large</span></td>
                                    </tr>
                                    <tr>
                                        <td>CSS</td>
                                        <td>156 KB</td>
                                        <td>3</td>
                                        <td>52 KB</td>
                                        <td><span class="badge bg-info">Acceptable</span></td>
                                    </tr>
                                    <tr>
                                        <td>Fonts</td>
                                        <td>89 KB</td>
                                        <td>4</td>
                                        <td>22 KB</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                    </tr>
                                    <tr>
                                        <td>HTML</td>
                                        <td>45 KB</td>
                                        <td>1</td>
                                        <td>45 KB</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                    </tr>
                                    <tr>
                                        <td>Other</td>
                                        <td>40 KB</td>
                                        <td>19</td>
                                        <td>2 KB</td>
                                        <td><span class="badge bg-success">Good</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Largest Resources</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Resource</th>
                                        <th>Size</th>
                                        <th>Type</th>
                                        <th>Potential Savings</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>hero-image.jpg</td>
                                        <td>456 KB</td>
                                        <td>Image</td>
                                        <td>280 KB (61% reduction)</td>
                                    </tr>
                                    <tr>
                                        <td>jquery.min.js</td>
                                        <td>87 KB</td>
                                        <td>JavaScript</td>
                                        <td>Already optimized</td>
                                    </tr>
                                    <tr>
                                        <td>bootstrap.bundle.min.js</td>
                                        <td>234 KB</td>
                                        <td>JavaScript</td>
                                        <td>Consider lazy loading</td>
                                    </tr>
                                    <tr>
                                        <td>main-styles.css</td>
                                        <td>89 KB</td>
                                        <td>CSS</td>
                                        <td>Remove unused styles</td>
                                    </tr>
                                    <tr>
                                        <td>background-image.png</td>
                                        <td>312 KB</td>
                                        <td>Image</td>
                                        <td>Convert to WebP (200 KB savings)</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Performance Analysis</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-danger">⚠ Total page size (2.1 MB) exceeds recommended limit for mobile devices</li>
                            <li class="list-group-item list-group-item-danger">⚠ Images account for 67% of total page size - major optimization opportunity</li>
                            <li class="list-group-item list-group-item-warning">⚠ JavaScript size (380 KB) could be reduced with code splitting</li>
                            <li class="list-group-item list-group-item-info">ℹ 47 total requests - consider reducing with file concatenation</li>
                            <li class="list-group-item list-group-item-success">✓ HTML and fonts are well-optimized</li>
                            <li class="list-group-item list-group-item-info">ℹ Enable GZIP compression for additional savings</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Optimization Recommendations</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <h6>High Impact</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">• Compress images (potential 500 KB savings)</li>
                                    <li class="list-group-item">• Convert images to WebP format</li>
                                    <li class="list-group-item">• Implement lazy loading for images</li>
                                    <li class="list-group-item">• Minify and compress JavaScript</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h6>Medium Impact</h6>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">• Remove unused CSS styles</li>
                                    <li class="list-group-item">• Combine CSS files</li>
                                    <li class="list-group-item">• Use font-display: swap</li>
                                    <li class="list-group-item">• Enable browser caching</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>SEO Impact Analysis</h5>
                        <div class="alert alert-info">
                            <strong>Core Web Vitals:</strong> Large page size may negatively impact LCP scores<br>
                            <strong>Mobile Performance:</strong> 2.1 MB exceeds recommended mobile page size limit<br>
                            <strong>Loading Speed:</strong> 3.2 second load time needs improvement<br>
                            <strong>User Experience:</strong> Large images may cause slow loading on mobile networks<br>
                            <strong>Recommendations:</strong> Prioritize image optimization and code minification
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Size Comparison</h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Your Page</h6>
                                        <h4 class="text-danger">2.1 MB</h4>
                                        <small>Current size</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Target Size</h6>
                                        <h4 class="text-success">1.0 MB</h4>
                                        <small>Recommended</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Potential Savings</h6>
                                        <h4 class="text-primary">700 KB</h4>
                                        <small>After optimization</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Industry Average</h6>
                                        <h4 class="text-warning">1.8 MB</h4>
                                        <small>Similar sites</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2500);
        });
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>