<?php
$page_title = "Link Shortener - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Link Shortener</h1>
                    <p class="fade-in">Create short, branded URLs for better sharing, tracking, and user experience.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Shorten Your Link</h3>
                        <form id="linkShortenerForm">
                            <div class="mb-3">
                                <label for="urlInput" class="form-label">Long URL</label>
                                <input type="url" class="form-control" id="urlInput" placeholder="https://example.com/very/long/url/that/needs/shortening" required>
                            </div>
                            <div class="mb-3">
                                <label for="customSlug" class="form-label">Custom Slug (Optional)</label>
                                <input type="text" class="form-control" id="customSlug" placeholder="my-custom-link" pattern="^[a-zA-Z0-9_-]+$" title="Only letters, numbers, hyphens, and underscores allowed">
                                <small class="form-text text-muted">Leave empty for auto-generated short URL</small>
                            </div>
                            <div class="mb-3">
                                <label for="linkType" class="form-label">Link Type</label>
                                <select class="form-control" id="linkType">
                                    <option value="temporary">Temporary (expires in 30 days)</option>
                                    <option value="permanent">Permanent</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Shorten URL</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>Shortened Link Created</h4>
                            <div id="linkResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to URL Shortening for SEO and Marketing</h2>

                        <p>URL shortening is essential for modern digital marketing, improving shareability, tracking, and user experience. A link shortener creates compact URLs that are easier to share across platforms while providing valuable analytics and branding opportunities. This comprehensive guide explores URL shortening best practices, SEO implications, and effective link management strategies.</p>

                        <h3>What is URL Shortening?</h3>

                        <p>URL shortening converts long, complex URLs into short, manageable links that redirect to the original destination. These shortened URLs are easier to share and track while maintaining the same functionality.</p>

                        <h4>How It Works</h4>

                        <ul>
                            <li><strong>URL Submission:</strong> User submits a long URL</li>
                            <li><strong>Code Generation:</strong> System creates unique short code</li>
                            <li><strong>Database Storage:</strong> Maps short URL to original URL</li>
                            <li><strong>Redirection:</strong> Short URL redirects to original destination</li>
                        </ul>

                        <h3>Why URL Shortening Matters for SEO</h3>

                        <p>Shortened URLs offer multiple benefits for search engine optimization:</p>

                        <h4>Improved Shareability</h4>

                        <p>Short URLs are more likely to be shared:</p>

                        <ul>
                            <li>Easier to include in social media posts</li>
                            <li>Better for email marketing campaigns</li>
                            <li>More readable in print materials</li>
                        </ul>

                        <h4>Click Tracking and Analytics</h4>

                        <p>Track link performance effectively:</p>

                        <ul>
                            <li>Monitor click-through rates</li>
                            <li>Analyze referral sources</li>
                            <li>Measure campaign effectiveness</li>
                        </ul>

                        <h4>Branding Opportunities</h4>

                        <p>Create branded short domains:</p>

                        <ul>
                            <li>Use custom domains (brand.ly, company.link)</li>
                            <li>Maintain brand consistency</li>
                            <li>Build trust with recognizable links</li>
                        </ul>

                        <h3>URL Shortening Best Practices</h3>

                        <h4>Custom Domains</h4>

                        <p>Use branded short domains:</p>

                        <ul>
                            <li>Register short, memorable domains</li>
                            <li>Match your brand name when possible</li>
                            <li>Consider industry-relevant terms</li>
                        </ul>

                        <h4>Link Management</h4>

                        <p>Organize and maintain links:</p>

                        <ul>
                            <li>Create logical naming conventions</li>
                            <li>Use folders or categories for organization</li>
                            <li>Regularly audit and update links</li>
                        </ul>

                        <h4>Expiration and Security</h4>

                        <p>Manage link lifecycle:</p>

                        <ul>
                            <li>Set appropriate expiration dates</li>
                            <li>Implement password protection when needed</li>
                            <li>Monitor for malicious use</li>
                        </ul>

                        <h3>SEO Considerations for Short URLs</h3>

                        <h4>Link Equity and Redirects</h4>

                        <p>Maintain SEO value with proper redirects:</p>

                        <ul>
                            <li>Use 301 redirects for permanent links</li>
                            <li>302 redirects for temporary campaigns</li>
                            <li>Avoid redirect chains that dilute link equity</li>
                        </ul>

                        <h4>Content and Anchor Text</h4>

                        <p>Optimize link presentation:</p>

                        <ul>
                            <li>Use descriptive anchor text</li>
                            <li>Ensure short URLs don't look spammy</li>
                            <li>Match link content with destination</li>
                        </ul>

                        <h4>Indexation and Crawling</h4>

                        <p>Ensure search engines can follow links:</p>

                        <ul>
                            <li>Don't block short URLs in robots.txt</li>
                            <li>Allow search engine crawling</li>
                            <li>Submit short URLs for indexing</li>
                        </ul>

                        <h3>Popular URL Shortening Services</h3>

                        <h4>Bitly</h4>

                        <p>Leading link management platform:</p>

                        <ul>
                            <li>Custom domains and branded links</li>
                            <li>Advanced analytics and tracking</li>
                            <li>Team collaboration features</li>
                        </ul>

                        <h4>TinyURL</h4>

                        <p>Simple and reliable shortening:</p>

                        <ul>
                            <li>Free basic service</li>
                            <li>Custom aliases available</li>
                            <li>Preview feature for safety</li>
                        </ul>

                        <h4>Rebrandly</h4>

                        <p>Branded link management:</p>

                        <ul>
                            <li>Multiple custom domains</li>
                            <li>Advanced link tracking</li>
                            <li>Integration with other tools</li>
                        </ul>

                        <h3>Advanced Link Shortening Features</h3>

                        <h4>Link Retargeting</h4>

                        <p>Personalize user experience:</p>

                        <ul>
                            <li>Device-specific redirects</li>
                            <li>Location-based targeting</li>
                            <li>A/B testing of destinations</li>
                        </ul>

                        <h4>Analytics and Reporting</h4>

                        <p>Comprehensive tracking capabilities:</p>

                        <ul>
                            <li>Real-time click tracking</li>
                            <li>Geographic and demographic data</li>
                            <li>Conversion attribution</li>
                        </ul>

                        <h4>Integration Capabilities</h4>

                        <p>Connect with other marketing tools:</p>

                        <ul>
                            <li>Social media management platforms</li>
                            <li>Email marketing services</li>
                            <li>CRM and analytics systems</li>
                        </ul>

                        <h3>Security and Safety Considerations</h3>

                        <h4>Link Safety</h4>

                        <p>Protect users from malicious links:</p>

                        <ul>
                            <li>Implement link scanning</li>
                            <li>Add preview pages for unknown links</li>
                            <li>Monitor for suspicious activity</li>
                        </ul>

                        <h4>Spam Prevention</h4>

                        <p>Prevent abuse of shortening services:</p>

                        <ul>
                            <li>Rate limiting and abuse detection</li>
                            <li>CAPTCHA for bulk operations</li>
                            <li>Manual review of suspicious links</li>
                        </ul>

                        <h3>URL Shortening for Different Platforms</h3>

                        <h4>Social Media</h4>

                        <p>Optimize for social sharing:</p>

                        <ul>
                            <li>Short URLs fit character limits</li>
                            <li>Track social media engagement</li>
                            <li>Create campaign-specific links</li>
                        </ul>

                        <h4>Email Marketing</h4>

                        <p>Improve email deliverability:</p>

                        <ul>
                            <li>Short links don't break in email clients</li>
                            <li>Track email click-through rates</li>
                            <li>Monitor link performance by campaign</li>
                        </ul>

                        <h4>Print Materials</h4>

                        <p>Perfect for offline marketing:</p>

                        <ul>
                            <li>Easy to type and remember</li>
                            <li>Fit on business cards and brochures</li>
                            <li>Track offline-to-online conversions</li>
                        </ul>

                        <h3>Measuring Link Performance</h3>

                        <p>Track the effectiveness of shortened links:</p>

                        <ul>
                            <li><strong>Click-through Rates:</strong> Measure link engagement</li>
                            <li><strong>Conversion Tracking:</strong> Monitor goal completions</li>
                            <li><strong>Geographic Data:</strong> Analyze audience locations</li>
                            <li><strong>Device Analytics:</strong> Track mobile vs desktop usage</li>
                        </ul>

                        <h3>Custom URL Shortener Implementation</h3>

                        <h4>Technical Requirements</h4>

                        <p>Build your own shortening service:</p>

                        <ul>
                            <li>Web server with redirect capabilities</li>
                            <li>Database for URL storage</li>
                            <li>Analytics tracking system</li>
                            <li>Security and rate limiting</li>
                        </ul>

                        <h4>Code Generation</h4>

                        <p>Create unique short codes:</p>

                        <ul>
                            <li>Use base62 encoding for short codes</li>
                            <li>Implement collision detection</li>
                            <li>Generate human-readable codes</li>
                        </ul>

                        <h3>Legal and Ethical Considerations</h3>

                        <h4>Link Ownership</h4>

                        <p>Respect link ownership rights:</p>

                        <ul>
                            <li>Don't shorten links without permission</li>
                            <li>Honor robots.txt and nofollow directives</li>
                            <li>Provide attribution when required</li>
                        </ul>

                        <h4>Transparency</h4>

                        <p>Be transparent about link destinations:</p>

                        <ul>
                            <li>Use preview pages for safety</li>
                            <li>Clearly indicate shortened links</li>
                            <li>Provide original URL information</li>
                        </ul>

                        <h3>Future of URL Shortening</h3>

                        <p>URL shortening technology evolves:</p>

                        <ul>
                            <li><strong>Blockchain Links:</strong> Decentralized link shortening</li>
                            <li><strong>AI-Powered Analytics:</strong> Advanced link insights</li>
                            <li><strong>Context-Aware Redirects:</strong> Smart destination selection</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>URL shortening is a powerful tool for modern digital marketing, improving shareability, tracking, and user experience. A link shortener creates compact URLs that maintain functionality while providing valuable analytics and branding opportunities. By following best practices and implementing proper tracking, you can maximize the effectiveness of your shortened links.</p>

                        <p>Remember that URL shortening should enhance user experience, not compromise it. Always prioritize link safety, transparency, and proper SEO implementation.</p>

                        <p>Combine URL shortening with other marketing tools like our <a href="<?php echo $base_url; ?>/tools/link-expander">link expander</a> and <a href="<?php echo $base_url; ?>/tools/social-share-counter">social share counter</a> for comprehensive link management and tracking.</p>

                        <p>For more information on URL shortening and link management, check the <a href="https://developers.google.com/webmasters/mobile-sites/mobile-seo/dynamic-serving" target="_blank" rel="noopener">Google URL shortening guidelines</a> and <a href="https://www.bitly.com/blog/what-is-a-url-shortener" target="_blank" rel="noopener">Bitly URL shortening guide</a>. Start shortening your URLs today and improve your link sharing and tracking capabilities.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔗</div>
                        <h4>Link Expander</h4>
                        <p>Expand shortened URLs to reveal their true destination and check for safety.</p>
                        <a href="<?php echo $base_url; ?>/tools/link-expander" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📱</div>
                        <h4>Social Share Counter</h4>
                        <p>Track and analyze social media shares, engagement metrics, and social signals.</p>
                        <a href="<?php echo $base_url; ?>/tools/social-share-counter" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>Google Cache Checker</h4>
                        <p>Check how Google caches and indexes your web pages for SEO analysis.</p>
                        <a href="<?php echo $base_url; ?>/tools/google-cache-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('linkShortenerForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const longUrl = document.getElementById('urlInput').value;
            const customSlug = document.getElementById('customSlug').value.trim();
            const linkType = document.getElementById('linkType').value;
            const resultsDiv = document.getElementById('linkResults');

            if (!longUrl) {
                alert('Please enter a URL to shorten.');
                return;
            }

            // Basic URL validation
            try {
                new URL(longUrl);
            } catch {
                alert('Please enter a valid URL.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Creating short URL...</p></div>';

            // In a real implementation, this would make an API call to create a short URL
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const shortCode = customSlug || 'abc123';
                const shortUrl = `https://loganix.link/${shortCode}`;

                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ URL Shortened Successfully!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Shortened Link</h5>
                            <div class="input-group">
                                <input type="text" class="form-control" id="shortUrlInput" value="${shortUrl}" readonly>
                                <button class="btn btn-outline-primary" type="button" onclick="copyToClipboard('${shortUrl}')">Copy</button>
                            </div>
                            <div class="mt-3">
                                <small class="text-muted">
                                    <strong>Original:</strong> ${longUrl}<br>
                                    <strong>Type:</strong> ${linkType === 'permanent' ? 'Permanent' : 'Temporary (30 days)'}<br>
                                    <strong>Created:</strong> ${new Date().toLocaleString()}
                                </small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Link Statistics</h5>
                            <div class="alert alert-info">
                                <strong>Clicks:</strong> 0 (new link)<br>
                                <strong>Status:</strong> Active<br>
                                <strong>Expires:</strong> ${linkType === 'permanent' ? 'Never' : '30 days from now'}<br>
                                <strong>Analytics:</strong> Enabled
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Link Preview & Sharing</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <h6>Share this link:</h6>
                                        <div class="d-flex gap-2 flex-wrap">
                                            <button class="btn btn-sm btn-outline-primary" onclick="shareOnPlatform('twitter', '${shortUrl}')">
                                                <i class="fab fa-twitter"></i> Twitter
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary" onclick="shareOnPlatform('facebook', '${shortUrl}')">
                                                <i class="fab fa-facebook"></i> Facebook
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary" onclick="shareOnPlatform('linkedin', '${shortUrl}')">
                                                <i class="fab fa-linkedin"></i> LinkedIn
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary" onclick="shareOnPlatform('email', '${shortUrl}')">
                                                <i class="fas fa-envelope"></i> Email
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <h6>QR Code</h6>
                                        <div class="text-center">
                                            <div style="width: 80px; height: 80px; border: 1px solid #dee2e6; border-radius: 4px; display: inline-flex; align-items: center; justify-content: center; background: #f8f9fa;">
                                                <small class="text-muted">QR Code</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>SEO & Analytics Features</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ Clean, branded short URL for better shareability</li>
                            <li class="list-group-item list-group-item-info">ℹ Click tracking and analytics enabled</li>
                            <li class="list-group-item list-group-item-info">ℹ Geographic and device analytics available</li>
                            <li class="list-group-item list-group-item-success">✓ Proper 301 redirect maintains SEO value</li>
                            <li class="list-group-item list-group-item-info">ℹ Link can be edited or deleted from your dashboard</li>
                            <li class="list-group-item list-group-item-warning">⚠ ${linkType === 'temporary' ? 'Temporary link expires in 30 days' : 'Permanent links never expire'}</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Best Practices Applied</h5>
                        <div class="alert alert-info">
                            <strong>URL Structure:</strong> Short, memorable, and branded<br>
                            <strong>Redirect Type:</strong> 301 (permanent) for SEO value preservation<br>
                            <strong>Analytics:</strong> Full click tracking and conversion attribution<br>
                            <strong>Security:</strong> Link scanning and abuse prevention<br>
                            <strong>Customization:</strong> ${customSlug ? 'Custom slug used' : 'Auto-generated optimized slug'}
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 1500);
        });

        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                // Show temporary success message
                const notification = document.createElement('div');
                notification.className = 'alert alert-success position-fixed';
                notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999;';
                notification.innerHTML = 'URL copied to clipboard!';
                document.body.appendChild(notification);
                setTimeout(() => document.body.removeChild(notification), 2000);
            });
        }

        function shareOnPlatform(platform, url) {
            let shareUrl = '';
            const text = 'Check out this link!';

            switch(platform) {
                case 'twitter':
                    shareUrl = `https://twitter.com/intent/tweet?text=${encodeURIComponent(text)}&url=${encodeURIComponent(url)}`;
                    break;
                case 'facebook':
                    shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
                    break;
                case 'linkedin':
                    shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`;
                    break;
                case 'email':
                    shareUrl = `mailto:?subject=${encodeURIComponent('Check this out')}&body=${encodeURIComponent(text + ' ' + url)}`;
                    break;
            }

            if (shareUrl) {
                window.open(shareUrl, '_blank', 'width=600,height=400');
            }
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>