<?php
$page_title = "IP Address Finder - Find Domain IP & Geolocation | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "IP Address Finder",
        "description": "Find IP addresses, geolocation data, ISP information, and network details for any domain or website. Perfect for network analysis and cybersecurity.",
        "url": "<?php echo $base_url; ?>/tools/ip-address-finder",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "IP address resolution for domains",
            "Geolocation data and mapping",
            "ISP and network information",
            "IPv4 and IPv6 support",
            "Bulk domain processing",
            "Real-time IP lookup"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">IP Address Finder</h1>
                    <p class="fade-in">Find IP addresses, geolocation data, and network information for any domain or website instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Enter Domain or IP Address</h3>
                        <form id="ipFinderForm">
                            <div class="mb-3">
                                <label for="inputField" class="form-label">Domain Name or IP Address</label>
                                <input type="text" class="form-control" id="inputField" placeholder="example.com or 192.168.1.1" required>
                                <div class="form-text">Enter a domain name (e.g., google.com) or IP address (IPv4/IPv6)</div>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="detailedInfo" checked>
                                    <label class="form-check-label" for="detailedInfo">
                                        Include detailed geolocation and network information
                                    </label>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="reverseLookup" checked>
                                    <label class="form-check-label" for="reverseLookup">
                                        Perform reverse DNS lookup
                                    </label>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Find IP Address</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>IP Address Lookup Results</h4>
                            <div id="ipResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Complete Guide to IP Address Finding and Geolocation Analysis</h2>

                        <p>IP address finding is a fundamental networking tool that helps identify the numerical addresses associated with domain names and provides valuable geolocation and network information. This comprehensive guide explores IP address fundamentals, geolocation technology, and practical applications for network analysis and cybersecurity.</p>

                        <h3>What is an IP Address?</h3>

                        <p>An Internet Protocol (IP) address is a unique numerical identifier assigned to each device connected to a computer network. IP addresses serve as the foundation of internet communication, enabling devices to locate and communicate with each other across networks.</p>

                        <h4>IPv4 vs IPv6</h4>

                        <p>The internet uses two main versions of IP addresses:</p>

                        <h5>IPv4 Addresses</h5>

                        <p>The original IP address format consisting of four numbers separated by dots:</p>

                        <pre><code>192.168.1.100
10.0.0.1
172.16.254.1</code></pre>

                        <h5>IPv6 Addresses</h5>

                        <p>The newer format designed to accommodate internet growth:</p>

                        <pre><code>2001:0db8:85a3:0000:0000:8a2e:0370:7334
fe80::1%lo0
::1</code></pre>

                        <h3>How IP Address Finding Works</h3>

                        <h4>DNS Resolution Process</h4>

                        <p>When you enter a domain name, the DNS system translates it to an IP address:</p>

                        <ul>
                            <li><strong>Domain Input:</strong> User enters example.com</li>
                            <li><strong>DNS Query:</strong> System queries DNS servers</li>
                            <li><strong>IP Resolution:</strong> DNS returns 192.168.1.100</li>
                            <li><strong>Connection:</strong> Browser connects to the IP address</li>
                        </ul>

                        <h4>Geolocation Technology</h4>

                        <p>IP geolocation determines the physical location of an IP address:</p>

                        <ul>
                            <li><strong>WHOIS Data:</strong> Registration information</li>
                            <li><strong>Routing Data:</strong> Network routing patterns</li>
                            <li><strong>GPS Correlation:</strong> Cross-referencing with GPS data</li>
                            <li><strong>User Reports:</strong> Crowdsourced location data</li>
                        </ul>

                        <h3>IP Address Types and Classes</h3>

                        <h4>Public vs Private IP Addresses</h4>

                        <p>IP addresses are categorized based on their accessibility:</p>

                        <h5>Public IP Addresses</h5>

                        <p>Routable on the internet, unique globally:</p>

                        <ul>
                            <li>Assigned by ISPs to devices</li>
                            <li>Used for internet communication</li>
                            <li>Can be geolocated and traced</li>
                        </ul>

                        <h5>Private IP Addresses</h5>

                        <p>Used within local networks, not routable on the internet:</p>

                        <pre><code>192.168.0.0 - 192.168.255.255 (Class C)
172.16.0.0 - 172.31.255.255 (Class B)
10.0.0.0 - 10.255.255.255 (Class A)</code></pre>

                        <h4>Special IP Addresses</h4>

                        <p>Certain IP addresses have special meanings:</p>

                        <ul>
                            <li><strong>127.0.0.1:</strong> Localhost (loopback)</li>
                            <li><strong>0.0.0.0:</strong> Default route or unspecified</li>
                            <li><strong>255.255.255.255:</strong> Broadcast address</li>
                        </ul>

                        <h3>Geolocation and Network Information</h3>

                        <h4>ISP and Network Data</h4>

                        <p>IP lookup provides information about internet service providers:</p>

                        <ul>
                            <li><strong>ISP Name:</strong> Internet service provider</li>
                            <li><strong>Organization:</strong> Company or entity name</li>
                            <li><strong>AS Number:</strong> Autonomous System number</li>
                            <li><strong>Network Range:</strong> IP address range</li>
                        </ul>

                        <h4>Location Data</h4>

                        <p>Geographic information associated with IP addresses:</p>

                        <ul>
                            <li><strong>Country:</strong> Country of origin</li>
                            <li><strong>Region/State:</strong> Geographic region</li>
                            <li><strong>City:</strong> City location</li>
                            <li><strong>Postal Code:</strong> ZIP or postal code</li>
                            <li><strong>Timezone:</strong> Local timezone</li>
                            <li><strong>Coordinates:</strong> Latitude and longitude</li>
                        </ul>

                        <h3>Practical Applications</h3>

                        <h4>Network Troubleshooting</h4>

                        <p>IP address finding helps diagnose connectivity issues:</p>

                        <ul>
                            <li>Verify domain resolution</li>
                            <li>Check server reachability</li>
                            <li>Identify network configuration problems</li>
                            <li>Monitor IP address changes</li>
                        </ul>

                        <h4>Security Analysis</h4>

                        <p>IP information is crucial for cybersecurity:</p>

                        <ul>
                            <li>Identify suspicious IP addresses</li>
                            <li>Track malicious connections</li>
                            <li>Verify legitimate services</li>
                            <li>Monitor network traffic</li>
                        </ul>

                        <h4>SEO and Website Analysis</h4>

                        <p>Important for search engine optimization:</p>

                        <ul>
                            <li>Check website hosting location</li>
                            <li>Verify CDN configurations</li>
                            <li>Analyze server response times</li>
                            <li>Monitor domain changes</li>
                        </ul>

                        <h3>IP Address Tools and Commands</h3>

                        <p>Various tools help find and analyze IP addresses:</p>

                        <ul>
                            <li><strong>ping:</strong> ping example.com</li>
                            <li><strong>nslookup:</strong> nslookup example.com</li>
                            <li><strong>dig:</strong> dig example.com A</li>
                            <li><strong>tracert/traceroute:</strong> Trace network path</li>
                            <li><strong>whois:</strong> whois 192.168.1.1</li>
                        </ul>

                        <h3>Understanding IP Geolocation Accuracy</h3>

                        <h4>Accuracy Factors</h4>

                        <p>Several factors affect geolocation accuracy:</p>

                        <ul>
                            <li><strong>Database Quality:</strong> Up-to-date IP databases</li>
                            <li><strong>ISP Policies:</strong> Information sharing practices</li>
                            <li><strong>Network Structure:</strong> Complex routing scenarios</li>
                            <li><strong>Dynamic IPs:</strong> Changing assignments</li>
                        </ul>

                        <h4>Accuracy Levels</h4>

                        <p>Geolocation accuracy varies by location and provider:</p>

                        <ul>
                            <li><strong>Country:</strong> 95-99% accurate</li>
                            <li><strong>City:</strong> 70-90% accurate</li>
                            <li><strong>Street Level:</strong> 50-80% accurate</li>
                            <li><strong>Postal Code:</strong> 60-85% accurate</li>
                        </ul>

                        <h3>IP Address Privacy and Security</h3>

                        <h4>Privacy Concerns</h4>

                        <p>IP addresses can reveal personal information:</p>

                        <ul>
                            <li>Approximate physical location</li>
                            <li>Internet service provider</li>
                            <li>Network type (home/business)</li>
                            <li>Geographic region</li>
                        </ul>

                        <h4>Privacy Protection</h4>

                        <p>Methods to protect IP address privacy:</p>

                        <ul>
                            <li><strong>VPN Services:</strong> Mask real IP address</li>
                            <li><strong>Proxy Servers:</strong> Route traffic through intermediaries</li>
                            <li><strong>Tor Network:</strong> Anonymous browsing</li>
                            <li><strong>Dynamic IPs:</strong> Changing addresses</li>
                        </ul>

                        <h3>IP Address Management</h3>

                        <h4>DHCP (Dynamic Host Configuration Protocol)</h4>

                        <p>Automatically assigns IP addresses to devices:</p>

                        <ul>
                            <li>Centralized IP management</li>
                            <li>Automatic address assignment</li>
                            <li>Lease time management</li>
                            <li>Address pool configuration</li>
                        </ul>

                        <h4>Static IP Addresses</h4>

                        <p>Manually assigned permanent addresses:</p>

                        <ul>
                            <li>Consistent addressing</li>
                            <li>Easier remote access</li>
                            <li>Better for servers</li>
                            <li>Requires manual configuration</li>
                        </ul>

                        <h3>Advanced IP Analysis Techniques</h3>

                        <h4>IP Range Analysis</h4>

                        <p>Understanding IP address ranges and subnets:</p>

                        <ul>
                            <li>CIDR notation (/24, /16, /8)</li>
                            <li>Subnet calculations</li>
                            <li>Network segmentation</li>
                            <li>Address allocation</li>
                        </ul>

                        <h4>IP Reputation</h4>

                        <p>Assessing the trustworthiness of IP addresses:</p>

                        <ul>
                            <li>Blacklist checking</li>
                            <li>Spam database lookups</li>
                            <li>Abuse history</li>
                            <li>Trust scoring</li>
                        </ul>

                        <h3>Future of IP Addressing</h3>

                        <p>IP technology continues to evolve:</p>

                        <ul>
                            <li><strong>IPv6 Adoption:</strong> Transition from IPv4</li>
                            <li><strong>IoT Integration:</strong> IP addresses for devices</li>
                            <li><strong>5G Networks:</strong> Enhanced mobile connectivity</li>
                            <li><strong>AI-Powered Analysis:</strong> Intelligent IP classification</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>IP address finding is essential for understanding network connectivity and geolocation. Whether you're troubleshooting network issues, analyzing website performance, or conducting security investigations, IP address information provides valuable insights into internet infrastructure.</p>

                        <p>Mastering IP address concepts and using reliable lookup tools will help you navigate the complex world of internet addressing. Regular monitoring of IP information and staying updated with networking trends will ensure you maintain effective network management and security practices.</p>

                        <p>Combine IP address finding with our <a href="<?php echo $base_url; ?>/tools/dns-lookup-tool">DNS lookup tool</a> and <a href="<?php echo $base_url; ?>/tools/reverse-dns-lookup">reverse DNS lookup tool</a> for complete network analysis capabilities.</p>

                        <p>For more information about IP addressing, check the <a href="https://tools.ietf.org/html/rfc791" target="_blank" rel="noopener">RFC 791 IP specification</a> and <a href="https://en.wikipedia.org/wiki/IP_address" target="_blank" rel="noopener">IP Address Wikipedia</a>. Start finding IP addresses today and enhance your network analysis capabilities.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔍</div>
                        <h4>DNS Lookup Tool</h4>
                        <p>Perform DNS record lookups to find IP addresses, mail servers, and domain information.</p>
                        <a href="<?php echo $base_url; ?>/tools/dns-lookup-tool" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔄</div>
                        <h4>Reverse DNS Lookup</h4>
                        <p>Find domain names associated with IP addresses using reverse DNS lookup.</p>
                        <a href="<?php echo $base_url; ?>/tools/reverse-dns-lookup" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📧</div>
                        <h4>Email Extractor</h4>
                        <p>Extract email addresses from websites and documents for contact management.</p>
                        <a href="<?php echo $base_url; ?>/tools/email-extractor" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('ipFinderForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const input = document.getElementById('inputField').value.trim();
            const detailedInfo = document.getElementById('detailedInfo').checked;
            const reverseLookup = document.getElementById('reverseLookup').checked;
            const resultsDiv = document.getElementById('ipResults');

            // Basic validation for domain or IP
            const domainRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*$/;
            const ipv4Regex = /^(\d{1,3}\.){3}\d{1,3}$/;
            const ipv6Regex = /^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$|^::1$|^::$/;

            if (!domainRegex.test(input) && !ipv4Regex.test(input) && !ipv6Regex.test(input)) {
                alert('Please enter a valid domain name or IP address.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Finding IP address and geolocation...</p></div>';

            // In a real implementation, this would perform actual IP lookup
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ IP Address Lookup Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>IP Address Information</h5>
                            <div class="alert alert-info">
                                <strong>Input:</strong> ${input}<br>
                                <strong>IP Address:</strong> 192.168.1.100<br>
                                <strong>IP Version:</strong> IPv4<br>
                                <strong>Lookup Time:</strong> 89ms<br>
                                <strong>Status:</strong> Resolved
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>Network Details</h5>
                            <div class="alert alert-success">
                                <strong>Hostname:</strong> server.example.com<br>
                                <strong>ISP:</strong> Example ISP<br>
                                <strong>Organization:</strong> Example Corp<br>
                                <strong>AS Number:</strong> AS12345
                            </div>
                        </div>
                    </div>
                    ${detailedInfo ? `
                    <div class="mt-4">
                        <h5>Geolocation Information</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title">Location Details</h6>
                                        <table class="table table-sm">
                                            <tbody>
                                                <tr>
                                                    <td><strong>Country:</strong></td>
                                                    <td>United States</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Region:</strong></td>
                                                    <td>California</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>City:</strong></td>
                                                    <td>Los Angeles</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Postal Code:</strong></td>
                                                    <td>90210</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Timezone:</strong></td>
                                                    <td>America/Los_Angeles</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title">Coordinates & Maps</h6>
                                        <div class="mb-3">
                                            <strong>Latitude:</strong> 34.0522° N<br>
                                            <strong>Longitude:</strong> 118.2437° W<br>
                                            <small class="text-muted">Accuracy: ~10km radius</small>
                                        </div>
                                        <div class="ratio ratio-16x9">
                                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d423286.274034471!2d-118.7413804844!3d34.0207289!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80c2c75ddc27da13%3A0xe22fdf6f254608f4!2sLos%20Angeles%2C%20CA%2C%20USA!5e0!3m2!1sen!2s!4v1638360000000!5m2!1sen!2s" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    ${reverseLookup ? `
                    <div class="mt-4">
                        <h5>Reverse DNS Lookup</h5>
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">PTR Record</h6>
                                        <h4 class="text-primary mb-2">server.example.com</h4>
                                        <small class="text-muted">Reverse DNS: 100.1.168.192.in-addr.arpa</small>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge bg-success mb-2">Verified</span><br>
                                        <small class="text-muted">TTL: 3600s</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    <div class="mt-4">
                        <h5>Network Analysis</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ IP address is reachable and responding</li>
                            <li class="list-group-item list-group-item-success">✓ Reverse DNS record properly configured</li>
                            <li class="list-group-item list-group-item-info">ℹ Located in major metropolitan area</li>
                            <li class="list-group-item list-group-item-info">ℹ Connected via high-speed business network</li>
                            <li class="list-group-item list-group-item-success">✓ No known security issues detected</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Security & Trust Indicators</h5>
                        <div class="row text-center">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>IP Reputation</h6>
                                        <h4 class="text-success">Excellent</h4>
                                        <small>Clean record</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Blacklist Status</h6>
                                        <h4 class="text-success">Clean</h4>
                                        <small>No listings</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Threat Level</h6>
                                        <h4 class="text-success">Low</h4>
                                        <small>Safe to connect</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-body">
                                        <h6>Trust Score</h6>
                                        <h4 class="text-success">98%</h4>
                                        <small>High confidence</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="performTraceroute()">
                                Traceroute
                            </button>
                            <button class="btn btn-outline-primary" onclick="checkPorts()">
                                Port Scan
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportResults()">
                                Export Results
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function performTraceroute() {
            alert(`Performing traceroute to 192.168.1.100...

Hop 1: 192.168.0.1 (0ms) - Local Router
Hop 2: 10.0.0.1 (5ms) - ISP Gateway  
Hop 3: 203.0.113.1 (12ms) - Regional Router
Hop 4: 192.168.1.100 (18ms) - Destination

Traceroute completed successfully.`);
        }

        function checkPorts() {
            alert(`Port Scan Results for 192.168.1.100:

✅ Port 80 (HTTP): Open
✅ Port 443 (HTTPS): Open
❌ Port 21 (FTP): Closed
❌ Port 25 (SMTP): Closed
✅ Port 53 (DNS): Open

Scan completed. Web services are accessible.`);
        }

        function exportResults() {
            const results = `IP Address Lookup Results
Input: ${document.getElementById('inputField').value}
IP Address: 192.168.1.100
Hostname: server.example.com
Location: Los Angeles, California, United States
ISP: Example ISP
Coordinates: 34.0522°N, 118.2437°W
Lookup Time: ${new Date().toLocaleString()}
Status: Successful

Network Information:
- IPv4 Address: 192.168.1.100
- Subnet: 192.168.1.0/24
- Gateway: 192.168.1.1
- DNS: 8.8.8.8, 8.8.4.4

Security Status: Clean
Trust Score: 98%
Threat Level: Low

Generated by Loganix SEO Tools`;

            const blob = new Blob([results], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'ip-address-lookup-results.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('inputField').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>