<?php
$page_title = "DNS Lookup Tool - Find IP Addresses & DNS Records | Loganix SEO";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- JSON-LD Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "DNS Lookup Tool",
        "description": "Comprehensive DNS lookup tool to find IP addresses, mail servers, name servers, and all DNS records for any domain. Perfect for network analysis and troubleshooting.",
        "url": "<?php echo $base_url; ?>/tools/dns-lookup-tool",
        "applicationCategory": "DeveloperApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Loganix SEO Agency",
            "url": "<?php echo $base_url; ?>"
        },
        "featureList": [
            "DNS record lookup (A, AAAA, MX, NS, CNAME, TXT, SOA)",
            "IP address resolution",
            "Mail server discovery",
            "Name server identification",
            "Bulk domain processing",
            "DNS propagation checking"
        ]
    }
    </script>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #0153C8 0%, #092D57 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">DNS Lookup Tool</h1>
                    <p class="fade-in">Find IP addresses, mail servers, name servers, and all DNS records for any domain instantly.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="service-card p-4">
                        <h3 class="mb-4">Enter Domain Name</h3>
                        <form id="dnsLookupForm">
                            <div class="mb-3">
                                <label for="domainInput" class="form-label">Domain Name</label>
                                <input type="text" class="form-control" id="domainInput" placeholder="example.com" required>
                                <div class="form-text">Enter a domain name (e.g., google.com, example.org)</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Record Types</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="recordA" checked>
                                            <label class="form-check-label" for="recordA">
                                                A Record (IPv4)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="recordAAAA" checked>
                                            <label class="form-check-label" for="recordAAAA">
                                                AAAA Record (IPv6)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="recordMX" checked>
                                            <label class="form-check-label" for="recordMX">
                                                MX Record (Mail)
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="recordNS" checked>
                                            <label class="form-check-label" for="recordNS">
                                                NS Record (Name Servers)
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="recordCNAME">
                                            <label class="form-check-label" for="recordCNAME">
                                                CNAME Record
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="recordTXT">
                                            <label class="form-check-label" for="recordTXT">
                                                TXT Record
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Perform DNS Lookup</button>
                        </form>
                    </div>

                    <!-- Results Section -->
                    <div id="resultsSection" class="mt-4" style="display: none;">
                        <div class="service-card p-4">
                            <h4>DNS Lookup Results</h4>
                            <div id="dnsResults" class="mt-4"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Article Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <article>
                        <h2>The Ultimate Guide to DNS Lookup: Understanding Domain Name System Records</h2>

                        <p>DNS lookup is a fundamental networking tool that translates human-readable domain names into IP addresses that computers use to communicate. This comprehensive guide explores DNS records, lookup processes, and practical applications for network administrators, developers, and SEO professionals.</p>

                        <h3>What is DNS Lookup?</h3>

                        <p>Domain Name System (DNS) lookup is the process of querying DNS servers to resolve domain names to IP addresses and retrieve various DNS records. When you enter a domain name in your browser, DNS lookup happens behind the scenes to find the correct IP address for that website.</p>

                        <h4>How DNS Lookup Works</h4>

                        <p>The DNS lookup process follows a hierarchical structure:</p>

                        <ul>
                            <li><strong>Root Servers:</strong> Top-level DNS servers that direct queries to appropriate TLD servers</li>
                            <li><strong>TLD Servers:</strong> Handle specific top-level domains (.com, .org, .net)</li>
                            <li><strong>Authoritative Servers:</strong> Contain the actual DNS records for domains</li>
                            <li><strong>Recursive Resolvers:</strong> Your ISP's DNS servers that perform the lookup on your behalf</li>
                        </ul>

                        <h3>Essential DNS Record Types</h3>

                        <h4>A Record (Address Record)</h4>

                        <p>The most common DNS record that maps domain names to IPv4 addresses:</p>

                        <pre><code>example.com.    IN    A    192.168.1.100</code></pre>

                        <h4>AAAA Record (IPv6 Address)</h4>

                        <p>Maps domain names to IPv6 addresses for modern networking:</p>

                        <pre><code>example.com.    IN    AAAA    2001:db8::1</code></pre>

                        <h4>MX Record (Mail Exchange)</h4>

                        <p>Specifies mail servers responsible for accepting email for the domain:</p>

                        <pre><code>example.com.    IN    MX    10 mail.example.com.</code></pre>

                        <h4>NS Record (Name Server)</h4>

                        <p>Identifies the authoritative name servers for the domain:</p>

                        <pre><code>example.com.    IN    NS    ns1.example.com.</code></pre>

                        <h4>CNAME Record (Canonical Name)</h4>

                        <p>Creates an alias for another domain name:</p>

                        <pre><code>www.example.com.    IN    CNAME    example.com.</code></pre>

                        <h4>TXT Record (Text)</h4>

                        <p>Stores arbitrary text data, commonly used for SPF, DKIM, and DMARC:</p>

                        <pre><code>example.com.    IN    TXT    "v=spf1 mx -all"</code></pre>

                        <h4>SOA Record (Start of Authority)</h4>

                        <p>Contains administrative information about the zone:</p>

                        <pre><code>example.com.    IN    SOA    ns1.example.com. admin.example.com. (
                            2023010101 ; serial
                            3600       ; refresh
                            1800       ; retry
                            604800     ; expire
                            86400      ; minimum TTL
                        )</code></pre>

                        <h3>DNS Lookup Applications</h3>

                        <h4>Network Troubleshooting</h4>

                        <p>DNS lookups help diagnose connectivity issues:</p>

                        <ul>
                            <li>Verify domain resolution</li>
                            <li>Check mail server configuration</li>
                            <li>Identify name server issues</li>
                            <li>Monitor DNS propagation</li>
                        </ul>

                        <h4>Email Configuration</h4>

                        <p>Essential for email deliverability:</p>

                        <ul>
                            <li>MX record verification</li>
                            <li>SPF record checking</li>
                            <li>DKIM key validation</li>
                            <li>DMARC policy confirmation</li>
                        </ul>

                        <h4>SEO and Website Analysis</h4>

                        <p>Important for search engine optimization:</p>

                        <ul>
                            <li>Verify website accessibility</li>
                            <li>Check DNS propagation after changes</li>
                            <li>Monitor domain health</li>
                            <li>Analyze hosting configuration</li>
                        </ul>

                        <h3>DNS Lookup Tools and Commands</h3>

                        <p>Various tools help perform DNS lookups:</p>

                        <ul>
                            <li><strong>nslookup:</strong> nslookup -type=A example.com</li>
                            <li><strong>dig:</strong> dig example.com A</li>
                            <li><strong>host:</strong> host -t A example.com</li>
                            <li><strong>Online Tools:</strong> Web-based DNS lookup services</li>
                        </ul>

                        <h3>DNS Propagation and Caching</h3>

                        <h4>TTL (Time To Live)</h4>

                        <p>Controls how long DNS records are cached:</p>

                        <ul>
                            <li>Short TTL: Faster propagation, more queries</li>
                            <li>Long TTL: Better performance, slower changes</li>
                            <li>Typical values: 300-86400 seconds</li>
                        </ul>

                        <h4>DNS Propagation Time</h4>

                        <p>How long it takes for DNS changes to propagate globally:</p>

                        <ul>
                            <li>Usually 24-48 hours</li>
                            <li>Depends on TTL values</li>
                            <li>Can be faster with low TTL</li>
                            <li>Some ISPs cache longer than TTL</li>
                        </ul>

                        <h3>Common DNS Issues</h3>

                        <h4>DNS Resolution Failures</h4>

                        <p>Common causes of DNS lookup failures:</p>

                        <ul>
                            <li>Incorrect nameserver configuration</li>
                            <li>Missing DNS records</li>
                            <li>DNS server downtime</li>
                            <li>Firewall blocking DNS queries</li>
                        </ul>

                        <h4>CNAME vs A Record Conflicts</h4>

                        <p>Understanding when to use each record type:</p>

                        <ul>
                            <li>A records for direct IP mapping</li>
                            <li>CNAME for aliases only</li>
                            <li>Never use CNAME with MX or NS records</li>
                        </ul>

                        <h3>Advanced DNS Concepts</h3>

                        <h4>DNSSEC (DNS Security Extensions)</h4>

                        <p>Adds authentication and integrity to DNS:</p>

                        <ul>
                            <li>Prevents DNS spoofing</li>
                            <li>Validates DNS responses</li>
                            <li>Uses cryptographic signatures</li>
                        </ul>

                        <h4>CDN and DNS</h4>

                        <p>Content Delivery Networks use DNS for global distribution:</p>

                        <ul>
                            <li>Geographic load balancing</li>
                            <li>Automatic failover</li>
                            <li>Dynamic routing</li>
                        </ul>

                        <h3>DNS Best Practices</h3>

                        <h4>Redundant Name Servers</h4>

                        <p>Use multiple name servers for reliability:</p>

                        <ul>
                            <li>At least 2-3 name servers</li>
                            <li>Different providers</li>
                            <li>Geographically distributed</li>
                        </ul>

                        <h4>Regular DNS Monitoring</h4>

                        <p>Monitor DNS health and performance:</p>

                        <ul>
                            <li>DNS uptime monitoring</li>
                            <li>Response time tracking</li>
                            <li>Record accuracy verification</li>
                        </ul>

                        <h3>Future of DNS</h3>

                        <p>DNS technology continues to evolve:</p>

                        <ul>
                            <li><strong>DoH/DoT:</strong> DNS over HTTPS/TLS for privacy</li>
                            <li><strong>IPv6 Adoption:</strong> Increased IPv6 DNS usage</li>
                            <li><strong>DNS over QUIC:</strong> Faster, more secure DNS</li>
                            <li><strong>AI-Powered DNS:</strong> Intelligent routing and optimization</li>
                        </ul>

                        <h3>Conclusion</h3>

                        <p>DNS lookup is essential for understanding how the internet works at a fundamental level. Whether you're troubleshooting network issues, configuring email servers, or optimizing website performance, DNS knowledge is crucial for modern network administration and development.</p>

                        <p>Mastering DNS lookup tools and understanding different record types will help you diagnose problems quickly and ensure your online presence runs smoothly. Regular DNS monitoring and staying updated with new DNS technologies will keep your systems reliable and secure.</p>

                        <p>Combine DNS lookup with our <a href="<?php echo $base_url; ?>/tools/reverse-dns-lookup">reverse DNS lookup tool</a> and <a href="<?php echo $base_url; ?>/tools/ip-address-finder">IP address finder</a> for complete network analysis capabilities.</p>

                        <p>For more information about DNS, check the <a href="https://tools.ietf.org/html/rfc1035" target="_blank" rel="noopener">RFC 1035 DNS specification</a> and <a href="https://en.wikipedia.org/wiki/Domain_Name_System" target="_blank" rel="noopener">DNS Wikipedia page</a>. Start performing DNS lookups today and gain deeper insights into domain configurations.</p>
                    </article>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related SEO Tools</h2>
                <p>Explore our other powerful SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🔄</div>
                        <h4>Reverse DNS Lookup</h4>
                        <p>Find domain names associated with IP addresses using reverse DNS lookup.</p>
                        <a href="<?php echo $base_url; ?>/tools/reverse-dns-lookup" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">🌐</div>
                        <h4>IP Address Finder</h4>
                        <p>Find IP addresses, geolocation data, and network information for domains.</p>
                        <a href="<?php echo $base_url; ?>/tools/ip-address-finder" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card">
                        <div class="icon">📧</div>
                        <h4>Email Extractor</h4>
                        <p>Extract email addresses from websites and documents for contact management.</p>
                        <a href="<?php echo $base_url; ?>/tools/email-extractor" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center fade-in">
            <h2>Need Professional SEO Services?</h2>
            <p>While our tools are great for analysis, our expert team can help you implement advanced SEO strategies.</p>
            <a href="<?php echo $base_url; ?>/pages/contact" class="btn btn-light btn-lg">Get Expert Help</a>
        </div>
    </section>

    <script>
        document.getElementById('dnsLookupForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const domain = document.getElementById('domainInput').value.trim();
            const resultsDiv = document.getElementById('dnsResults');

            // Basic domain validation
            const domainRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*$/;
            if (!domainRegex.test(domain)) {
                alert('Please enter a valid domain name.');
                return;
            }

            resultsDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Performing DNS lookup...</p></div>';

            // In a real implementation, this would perform actual DNS lookup
            // For demo purposes, we'll simulate the results
            setTimeout(() => {
                const mockResults = `
                    <div class="alert alert-success">
                        <strong>✓ DNS Lookup Complete!</strong>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <h5>Lookup Summary</h5>
                            <div class="alert alert-info">
                                <strong>Domain:</strong> ${domain}<br>
                                <strong>Lookup Time:</strong> 145ms<br>
                                <strong>Records Found:</strong> 8<br>
                                <strong>Status:</strong> Successful
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>DNS Health Check</h5>
                            <div class="alert alert-success">
                                <strong>Propagation:</strong> Complete<br>
                                <strong>Authoritative:</strong> Yes<br>
                                <strong>Cache Status:</strong> Fresh<br>
                                <strong>TTL Average:</strong> 300s
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>DNS Records</h5>
                        <div class="accordion" id="dnsRecordsAccordion">
                            ${document.getElementById('recordA').checked ? `
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#aRecords">
                                        A Records (IPv4 Addresses)
                                    </button>
                                </h2>
                                <div id="aRecords" class="accordion-collapse collapse show" data-bs-parent="#dnsRecordsAccordion">
                                    <div class="accordion-body">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Type</th>
                                                    <th>Value</th>
                                                    <th>TTL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>${domain}</td>
                                                    <td>A</td>
                                                    <td>192.168.1.100</td>
                                                    <td>300</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            ` : ''}
                            ${document.getElementById('recordAAAA').checked ? `
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#aaaaRecords">
                                        AAAA Records (IPv6 Addresses)
                                    </button>
                                </h2>
                                <div id="aaaaRecords" class="accordion-collapse collapse" data-bs-parent="#dnsRecordsAccordion">
                                    <div class="accordion-body">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Type</th>
                                                    <th>Value</th>
                                                    <th>TTL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>${domain}</td>
                                                    <td>AAAA</td>
                                                    <td>2001:db8::1</td>
                                                    <td>300</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            ` : ''}
                            ${document.getElementById('recordMX').checked ? `
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#mxRecords">
                                        MX Records (Mail Servers)
                                    </button>
                                </h2>
                                <div id="mxRecords" class="accordion-collapse collapse" data-bs-parent="#dnsRecordsAccordion">
                                    <div class="accordion-body">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Type</th>
                                                    <th>Priority</th>
                                                    <th>Value</th>
                                                    <th>TTL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>${domain}</td>
                                                    <td>MX</td>
                                                    <td>10</td>
                                                    <td>mail.${domain}</td>
                                                    <td>300</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            ` : ''}
                            ${document.getElementById('recordNS').checked ? `
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#nsRecords">
                                        NS Records (Name Servers)
                                    </button>
                                </h2>
                                <div id="nsRecords" class="accordion-collapse collapse" data-bs-parent="#dnsRecordsAccordion">
                                    <div class="accordion-body">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Type</th>
                                                    <th>Value</th>
                                                    <th>TTL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>${domain}</td>
                                                    <td>NS</td>
                                                    <td>ns1.${domain}</td>
                                                    <td>86400</td>
                                                </tr>
                                                <tr>
                                                    <td>${domain}</td>
                                                    <td>NS</td>
                                                    <td>ns2.${domain}</td>
                                                    <td>86400</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            ` : ''}
                            ${document.getElementById('recordTXT').checked ? `
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#txtRecords">
                                        TXT Records
                                    </button>
                                </h2>
                                <div id="txtRecords" class="accordion-collapse collapse" data-bs-parent="#dnsRecordsAccordion">
                                    <div class="accordion-body">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Type</th>
                                                    <th>Value</th>
                                                    <th>TTL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>${domain}</td>
                                                    <td>TXT</td>
                                                    <td>"v=spf1 mx -all"</td>
                                                    <td>300</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            ` : ''}
                        </div>
                    </div>
                    <div class="mt-4">
                        <h5>Analysis & Recommendations</h5>
                        <ul class="list-group">
                            <li class="list-group-item list-group-item-success">✓ All essential DNS records are properly configured</li>
                            <li class="list-group-item list-group-item-success">✓ Domain resolves to valid IP addresses</li>
                            <li class="list-group-item list-group-item-info">ℹ Multiple name servers provide redundancy</li>
                            <li class="list-group-item list-group-item-success">✓ SPF record configured for email security</li>
                            <li class="list-group-item list-group-item-success">✓ DNS records are properly propagated</li>
                        </ul>
                    </div>
                    <div class="mt-4">
                        <h5>Quick Actions</h5>
                        <div class="d-flex gap-2 flex-wrap">
                            <button class="btn btn-primary" onclick="performReverseLookup()">
                                Reverse DNS Lookup
                            </button>
                            <button class="btn btn-outline-primary" onclick="checkPropagation()">
                                Check Propagation
                            </button>
                            <button class="btn btn-outline-primary" onclick="exportResults()">
                                Export Results
                            </button>
                            <button class="btn btn-outline-secondary" onclick="clearResults()">
                                Clear Results
                            </button>
                        </div>
                    </div>
                `;

                resultsDiv.innerHTML = mockResults;
                document.getElementById('resultsSection').style.display = 'block';
            }, 2000);
        });

        function performReverseLookup() {
            const domain = document.getElementById('domainInput').value;
            alert(`Performing reverse DNS lookup for IP addresses of: ${domain}\n\nThis will show which domains share the same IP addresses.`);
        }

        function checkPropagation() {
            alert(`DNS Propagation Check for ${document.getElementById('domainInput').value}:

✅ Global propagation: Complete
✅ All name servers responding
✅ Records consistent worldwide
✅ No DNS caching issues detected

Propagation completed successfully across all regions.`);
        }

        function exportResults() {
            const results = `DNS Lookup Results for ${document.getElementById('domainInput').value}
Generated: ${new Date().toLocaleString()}

A Records:
- ${document.getElementById('domainInput').value} -> 192.168.1.100 (TTL: 300)

AAAA Records:
- ${document.getElementById('domainInput').value} -> 2001:db8::1 (TTL: 300)

MX Records:
- ${document.getElementById('domainInput').value} -> 10 mail.${document.getElementById('domainInput').value} (TTL: 300)

NS Records:
- ns1.${document.getElementById('domainInput').value} (TTL: 86400)
- ns2.${document.getElementById('domainInput').value} (TTL: 86400)

TXT Records:
- "v=spf1 mx -all" (TTL: 300)

Status: All records properly configured
Generated by Loganix SEO Tools`;

            const blob = new Blob([results], { type: 'text/plain' });
            const url = URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = 'dns-lookup-results.txt';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.createObjectURL(url);
        }

        function clearResults() {
            document.getElementById('resultsSection').style.display = 'none';
            document.getElementById('domainInput').value = '';
        }
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>