<?php
$page_title = "Backlink Checker - Loganix SEO Agency";
include_once __DIR__ . '/../../includes/config.php';
include_once __DIR__ . '/../../includes/header.php';
?>

    <!-- Tool Hero Section -->
    <section class="hero-section" style="background: linear-gradient(135deg, #FF4B91 0%, #E0357A 100%);">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 text-center hero-content">
                    <h1 class="fade-in" style="font-size: 2.5rem;">Free Backlink Checker</h1>
                    <p class="fade-in">Analyze your website's backlink profile and discover new link building opportunities with our comprehensive backlink checker tool.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Interface -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="service-card p-4 mb-4">
                        <h3 class="text-center mb-4">Check Your Backlinks</h3>
                        <form id="backlinkForm">
                            <div class="mb-3">
                                <label for="domain" class="form-label">Enter Domain or URL</label>
                                <input type="url" class="form-control form-control-lg" id="domain" placeholder="https://example.com" required>
                                <div class="form-text">Enter your domain name or full URL to analyze backlinks</div>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-lg px-5" id="checkBtn">
                                    <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                    Check Backlinks
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Results Section (Hidden by default) -->
                    <div id="resultsSection" class="d-none">
                        <div class="service-card p-4">
                            <h4 class="mb-3">Backlink Analysis Results</h4>

                            <!-- Summary Stats -->
                            <div class="row mb-4">
                                <div class="col-md-3 text-center">
                                    <div style="font-size: 2rem; color: var(--primary-accent); font-weight: bold;">1,247</div>
                                    <small class="text-muted">Total Backlinks</small>
                                </div>
                                <div class="col-md-3 text-center">
                                    <div style="font-size: 2rem; color: var(--primary-accent); font-weight: bold;">89</div>
                                    <small class="text-muted">Referring Domains</small>
                                </div>
                                <div class="col-md-3 text-center">
                                    <div style="font-size: 2rem; color: var(--primary-accent); font-weight: bold;">67</div>
                                    <small class="text-muted">Domain Authority</small>
                                </div>
                                <div class="col-md-3 text-center">
                                    <div style="font-size: 2rem; color: var(--primary-accent); font-weight: bold;">4.2</div>
                                    <small class="text-muted">Trust Score</small>
                                </div>
                            </div>

                            <!-- Backlink Types Chart -->
                            <div class="mb-4">
                                <h5>Backlink Types Distribution</h5>
                                <div style="width: 100%; height: 200px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; color: #6c757d;">
                                    📊 Backlink Types Chart Placeholder
                                </div>
                            </div>

                            <!-- Top Backlinks Table -->
                            <div class="mb-4">
                                <h5>Top Backlinks</h5>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Source URL</th>
                                                <th>Anchor Text</th>
                                                <th>DA</th>
                                                <th>Type</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><a href="#" target="_blank">example-blog.com/guest-post</a></td>
                                                <td>SEO agency</td>
                                                <td>85</td>
                                                <td><span class="badge bg-success">Dofollow</span></td>
                                            </tr>
                                            <tr>
                                                <td><a href="#" target="_blank">tech-news-site.com/article</a></td>
                                                <td>best SEO services</td>
                                                <td>78</td>
                                                <td><span class="badge bg-success">Dofollow</span></td>
                                            </tr>
                                            <tr>
                                                <td><a href="#" target="_blank">marketing-forum.com/thread</a></td>
                                                <td>Loganix SEO</td>
                                                <td>65</td>
                                                <td><span class="badge bg-warning">Nofollow</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Recommendations -->
                            <div class="alert alert-info">
                                <h6><i class="fas fa-lightbulb"></i> Recommendations</h6>
                                <ul class="mb-0">
                                    <li>Focus on acquiring more backlinks from DA 70+ websites</li>
                                    <li>Diversify your anchor text to avoid over-optimization</li>
                                    <li>Consider guest posting on industry-leading publications</li>
                                    <li>Monitor for any toxic backlinks that may harm your rankings</li>
                                </ul>
                            </div>

                            <div class="text-center mt-4">
                                <button class="btn btn-outline-primary me-2">Export Report</button>
                                <button class="btn btn-primary">Check Another Domain</button>
                            </div>
                        </div>
                    </div>

                    <!-- Sample Results Notice -->
                    <div class="alert alert-warning">
                        <strong>Note:</strong> This is a demonstration tool. In a real implementation, this would connect to backlink analysis APIs to provide actual data.
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features -->
    <section class="why-choose-us">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Tool Features</h2>
                <p>Everything you need to analyze your backlink profile</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="feature-item">
                        <div class="icon">📊</div>
                        <div>
                            <h5>Comprehensive Analysis</h5>
                            <p>Get detailed insights into your backlink profile including domain authority, trust flow, and citation flow.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="feature-item">
                        <div class="icon">🔍</div>
                        <div>
                            <h5>Competitor Research</h5>
                            <p>Compare your backlink profile with competitors to identify opportunities and gaps.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="feature-item">
                        <div class="icon">📈</div>
                        <div>
                            <h5>Historical Data</h5>
                            <p>Track changes in your backlink profile over time to measure the impact of your link building efforts.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="feature-item">
                        <div class="icon">⚠️</div>
                        <div>
                            <h5>Toxic Link Detection</h5>
                            <p>Identify potentially harmful backlinks that could negatively impact your search rankings.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="feature-item">
                        <div class="icon">🎯</div>
                        <div>
                            <h5>Link Building Opportunities</h5>
                            <p>Discover new websites and opportunities for building high-quality backlinks.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="feature-item">
                        <div class="icon">📋</div>
                        <div>
                            <h5>Detailed Reports</h5>
                            <p>Export comprehensive reports with actionable insights and recommendations.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works -->
    <section class="py-5">
        <div class="container">
            <div class="section-title fade-in">
                <h2>How It Works</h2>
                <p>Get your backlink analysis in three simple steps</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="text-center">
                        <div style="width: 80px; height: 80px; background: var(--primary-accent); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 2rem; margin: 0 auto 1rem; font-weight: bold;">1</div>
                        <h5>Enter Your Domain</h5>
                        <p>Simply enter your website URL or domain name in the tool above.</p>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="text-center">
                        <div style="width: 80px; height: 80px; background: var(--primary-accent); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 2rem; margin: 0 auto 1rem; font-weight: bold;">2</div>
                        <h5>Analysis Processing</h5>
                        <p>Our tool crawls and analyzes your backlink profile using advanced algorithms.</p>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="text-center">
                        <div style="width: 80px; height: 80px; background: var(--primary-accent); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 2rem; margin: 0 auto 1rem; font-weight: bold;">3</div>
                        <h5>Get Results</h5>
                        <p>Receive detailed backlink analysis with actionable insights and recommendations.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="why-choose-us">
        <div class="container">
            <div class="section-title fade-in">
                <h2>Related Tools</h2>
                <p>Explore our other SEO analysis tools</p>
            </div>
            <div class="row">
                <div class="col-lg-4 fade-in">
                    <div class="service-card text-center">
                        <div class="icon" style="font-size: 3rem;">📊</div>
                        <h5>Domain Authority Checker</h5>
                        <p>Check domain authority scores and SEO metrics for any website.</p>
                        <a href="<?php echo $base_url; ?>/tools/domain-authority" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card text-center">
                        <div class="icon" style="font-size: 3rem;">🔍</div>
                        <h5>Keyword Research</h5>
                        <p>Discover high-value keywords with search volume and competition data.</p>
                        <a href="<?php echo $base_url; ?>/tools/keyword-research" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
                <div class="col-lg-4 fade-in">
                    <div class="service-card text-center">
                        <div class="icon" style="font-size: 3rem;">📈</div>
                        <h5>SERP Position Checker</h5>
                        <p>Track your keyword rankings across different search engines.</p>
                        <a href="<?php echo $base_url; ?>/tools/serp-checker" class="btn btn-primary mt-3">Use Tool</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        // Simple form handling for demo
        document.getElementById('backlinkForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const checkBtn = document.getElementById('checkBtn');
            const spinner = checkBtn.querySelector('.spinner-border');
            const resultsSection = document.getElementById('resultsSection');

            // Show loading state
            checkBtn.disabled = true;
            spinner.classList.remove('d-none');

            // Simulate API call
            setTimeout(() => {
                checkBtn.disabled = false;
                spinner.classList.add('d-none');
                resultsSection.classList.remove('d-none');

                // Scroll to results
                resultsSection.scrollIntoView({ behavior: 'smooth' });
            }, 2000);
        });
    </script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>